/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SecurityConfigurationTest {
    SecurityConfigurationTest() {
    }

    @Test
    public void keytabWithoutPrincipalShouldThrowException() {
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.KERBEROS_LOGIN_KEYTAB, (Object)"keytab.file");
        IllegalConfigurationException e = (IllegalConfigurationException)Assertions.assertThrows(IllegalConfigurationException.class, () -> new SecurityConfiguration(configuration));
        Assertions.assertTrue((boolean)e.getMessage().contains("either both keytab and principal must be defined, or neither"));
    }

    @Test
    public void principalWithoutKeytabShouldThrowException() {
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, (Object)"principal");
        IllegalConfigurationException e = (IllegalConfigurationException)Assertions.assertThrows(IllegalConfigurationException.class, () -> new SecurityConfiguration(configuration));
        Assertions.assertTrue((boolean)e.getMessage().contains("either both keytab and principal must be defined, or neither"));
    }

    @Test
    public void notExistingKeytabShouldThrowException() {
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.KERBEROS_LOGIN_KEYTAB, (Object)"nonexistingkeytab.file");
        configuration.set(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, (Object)"principal");
        IllegalConfigurationException e = (IllegalConfigurationException)Assertions.assertThrows(IllegalConfigurationException.class, () -> new SecurityConfiguration(configuration));
        Assertions.assertTrue((boolean)e.getMessage().contains("nonexistingkeytab.file"));
        Assertions.assertTrue((boolean)e.getMessage().contains("doesn't exist"));
    }
}

