/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AbstractMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricsFilterParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AbstractMetricsHandlerTest
extends TestLogger {
    private static final String TEST_METRIC_NAME = "test_counter";
    private static final int TEST_METRIC_VALUE = 1000;
    private static final String METRICS_FILTER_QUERY_PARAM = "get";
    @Mock
    private MetricFetcher mockMetricFetcher;
    @Mock
    private DispatcherGateway mockDispatcherGateway;
    private TestMetricsHandler testMetricsHandler;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)((Object)this));
        MetricStore metricStore = new MetricStore();
        metricStore.add((MetricDump)new MetricDump.CounterDump((QueryScopeInfo)new QueryScopeInfo.JobManagerQueryScopeInfo(), TEST_METRIC_NAME, 1000L));
        Mockito.when((Object)this.mockMetricFetcher.getMetricStore()).thenReturn((Object)metricStore);
        this.testMetricsHandler = new TestMetricsHandler((GatewayRetriever)new GatewayRetriever<DispatcherGateway>(){

            public CompletableFuture<DispatcherGateway> getFuture() {
                return CompletableFuture.completedFuture(AbstractMetricsHandlerTest.this.mockDispatcherGateway);
            }
        }, Time.milliseconds((long)50L), Collections.emptyMap(), (MessageHeaders)new TestMetricsHeaders(), this.mockMetricFetcher);
    }

    @Test
    public void testListMetrics() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assert.assertTrue((boolean)completableFuture.isDone());
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        MatcherAssert.assertThat((Object)metricCollectionResponseBody.getMetrics(), (Matcher)Matchers.hasSize((int)1));
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        MatcherAssert.assertThat((Object)metric.getId(), (Matcher)Matchers.equalTo((Object)TEST_METRIC_NAME));
        MatcherAssert.assertThat((Object)metric.getValue(), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void testReturnEmptyListIfNoComponentMetricStore() throws Exception {
        this.testMetricsHandler.returnComponentMetricStore = false;
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assert.assertTrue((boolean)completableFuture.isDone());
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        MatcherAssert.assertThat((Object)metricCollectionResponseBody.getMetrics(), (Matcher)Matchers.empty());
    }

    @Test
    public void testGetMetrics() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap(METRICS_FILTER_QUERY_PARAM, Collections.singletonList(TEST_METRIC_NAME)), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assert.assertTrue((boolean)completableFuture.isDone());
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        MatcherAssert.assertThat((Object)metricCollectionResponseBody.getMetrics(), (Matcher)Matchers.hasSize((int)1));
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        MatcherAssert.assertThat((Object)metric.getId(), (Matcher)Matchers.equalTo((Object)TEST_METRIC_NAME));
        MatcherAssert.assertThat((Object)metric.getValue(), (Matcher)Matchers.equalTo((Object)Integer.toString(1000)));
    }

    @Test
    public void testReturnEmptyListIfRequestedMetricIsUnknown() throws Exception {
        CompletableFuture completableFuture = this.testMetricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap(METRICS_FILTER_QUERY_PARAM, Collections.singletonList("unknown_metric")), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assert.assertTrue((boolean)completableFuture.isDone());
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        MatcherAssert.assertThat((Object)metricCollectionResponseBody.getMetrics(), (Matcher)Matchers.empty());
    }

    private static class TestMessageParameters
    extends MessageParameters {
        private final MetricsFilterParameter metricsFilterParameter = new MetricsFilterParameter();

        private TestMessageParameters() {
        }

        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.emptyList();
        }

        public Collection<MessageQueryParameter<?>> getQueryParameters() {
            return Collections.singletonList(this.metricsFilterParameter);
        }
    }

    private static class TestMetricsHeaders
    extends AbstractMetricsHeaders<TestMessageParameters> {
        private TestMetricsHeaders() {
        }

        public TestMessageParameters getUnresolvedMessageParameters() {
            return new TestMessageParameters();
        }

        public String getTargetRestEndpointURL() {
            return "/";
        }

        public String getDescription() {
            return "";
        }
    }

    private static class TestMetricsHandler
    extends AbstractMetricsHandler<TestMessageParameters> {
        private boolean returnComponentMetricStore = true;

        private TestMetricsHandler(GatewayRetriever<DispatcherGateway> leaderRetriever, Time timeout, Map<String, String> headers, MessageHeaders<EmptyRequestBody, MetricCollectionResponseBody, TestMessageParameters> messageHeaders, MetricFetcher metricFetcher) {
            super(leaderRetriever, timeout, headers, messageHeaders, metricFetcher);
        }

        @Nullable
        protected MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody> request, MetricStore metricStore) {
            return this.returnComponentMetricStore ? metricStore.getJobManager() : null;
        }
    }
}

