/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import junit.framework.TestCase;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.failover.flip1.ExponentialDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.FixedDelayRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.NoRestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategy;
import org.apache.flink.runtime.executiongraph.failover.flip1.RestartBackoffTimeStrategyFactoryLoader;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;

public class RestartBackoffTimeStrategyFactoryLoaderTest
extends TestLogger {
    private static final RestartStrategies.RestartStrategyConfiguration DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION = RestartStrategies.fallBackRestart();

    @Test
    public void testNoRestartStrategySpecifiedInJobConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "failure-rate");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.noRestart(), (Configuration)conf, (boolean)false);
        TestCase.assertEquals((Object)NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE, (Object)factory);
    }

    @Test
    public void testFixedDelayRestartStrategySpecifiedInJobConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "failure-rate");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.fixedDelayRestart((int)1, (Time)Time.milliseconds((long)1000L)), (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory.class));
    }

    @Test
    public void testExponentialDelayRestartStrategySpecifiedInJobConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "failure-rate");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.exponentialDelayRestart((Time)Time.milliseconds((long)1L), (Time)Time.milliseconds((long)1000L), (double)1.1, (Time)Time.milliseconds((long)2000L), (double)0.0), (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory.class));
    }

    @Test
    public void testFailureRateRestartStrategySpecifiedInJobConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "fixed-delay");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.failureRateRestart((int)1, (Time)Time.milliseconds((long)1000L), (Time)Time.milliseconds((long)1000L)), (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory.class));
    }

    @Test
    public void testNoRestartStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "none");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)conf, (boolean)false);
        TestCase.assertEquals((Object)NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.INSTANCE, (Object)factory);
    }

    @Test
    public void testFixedDelayStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "fixed-delay");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(FixedDelayRestartBackoffTimeStrategy.FixedDelayRestartBackoffTimeStrategyFactory.class));
    }

    @Test
    public void testExponentialDelayStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "exponential-delay");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(ExponentialDelayRestartBackoffTimeStrategy.ExponentialDelayRestartBackoffTimeStrategyFactory.class));
    }

    @Test
    public void testFailureRateStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "failure-rate");
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)conf, (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(FailureRateRestartBackoffTimeStrategy.FailureRateRestartBackoffTimeStrategyFactory.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidStrategySpecifiedInClusterConfig() {
        Configuration conf = new Configuration();
        conf.setString(RestartStrategyOptions.RESTART_STRATEGY, "invalid-strategy");
        RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)conf, (boolean)false);
    }

    @Test
    public void testNoStrategySpecifiedWhenCheckpointingEnabled() {
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)new Configuration(), (boolean)true);
        RestartBackoffTimeStrategy strategy = factory.create();
        MatcherAssert.assertThat((Object)strategy, (Matcher)IsInstanceOf.instanceOf(FixedDelayRestartBackoffTimeStrategy.class));
        FixedDelayRestartBackoffTimeStrategy fixedDelayStrategy = (FixedDelayRestartBackoffTimeStrategy)strategy;
        TestCase.assertEquals((long)RestartBackoffTimeStrategyFactoryLoader.DEFAULT_RESTART_DELAY, (long)fixedDelayStrategy.getBackoffTime());
        TestCase.assertEquals((int)Integer.MAX_VALUE, (int)fixedDelayStrategy.getMaxNumberRestartAttempts());
    }

    @Test
    public void testNoStrategySpecifiedWhenCheckpointingDisabled() {
        RestartBackoffTimeStrategy.Factory factory = RestartBackoffTimeStrategyFactoryLoader.createRestartBackoffTimeStrategyFactory((RestartStrategies.RestartStrategyConfiguration)DEFAULT_JOB_LEVEL_RESTART_CONFIGURATION, (Configuration)new Configuration(), (boolean)false);
        MatcherAssert.assertThat((Object)factory, (Matcher)IsInstanceOf.instanceOf(NoRestartBackoffTimeStrategy.NoRestartBackoffTimeStrategyFactory.class));
    }
}

