/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class CheckpointStorageLocationReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] encodedReference;
    private static final CheckpointStorageLocationReference DEFAULT = new CheckpointStorageLocationReference();

    public CheckpointStorageLocationReference(byte[] encodedReference) {
        Preconditions.checkNotNull((Object)encodedReference);
        Preconditions.checkArgument((encodedReference.length > 0 ? 1 : 0) != 0);
        this.encodedReference = encodedReference;
    }

    private CheckpointStorageLocationReference() {
        this.encodedReference = null;
    }

    public byte[] getReferenceBytes() {
        return this.encodedReference != null ? this.encodedReference : new byte[]{};
    }

    public boolean isDefaultReference() {
        return this.encodedReference == null;
    }

    public int hashCode() {
        return this.encodedReference == null ? 2059243550 : Arrays.hashCode(this.encodedReference);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == CheckpointStorageLocationReference.class && Arrays.equals(this.encodedReference, ((CheckpointStorageLocationReference)obj).encodedReference);
    }

    public String toString() {
        return this.encodedReference == null ? "(default)" : StringUtils.byteToHexString((byte[])this.encodedReference, (int)0, (int)this.encodedReference.length);
    }

    protected final Object readResolve() throws ObjectStreamException {
        return this.encodedReference == null ? DEFAULT : this;
    }

    public static CheckpointStorageLocationReference getDefault() {
        return DEFAULT;
    }
}

