/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarIdPathParameter;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class JarDeleteHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, EmptyResponseBody, JarDeleteMessageParameters> {
    private final Path jarDir;
    private final Executor executor;

    public JarDeleteHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, EmptyResponseBody, JarDeleteMessageParameters> messageHeaders, Path jarDir, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.jarDir = Objects.requireNonNull(jarDir);
        this.executor = Objects.requireNonNull(executor);
    }

    protected CompletableFuture<EmptyResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, JarDeleteMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        String jarId = (String)request.getPathParameter(JarIdPathParameter.class);
        return CompletableFuture.supplyAsync(() -> {
            Path jarToDelete = this.jarDir.resolve(jarId);
            if (!Files.exists(jarToDelete, new LinkOption[0])) {
                throw new CompletionException(new RestHandlerException(String.format("File %s does not exist in %s.", jarId, this.jarDir), HttpResponseStatus.BAD_REQUEST));
            }
            try {
                Files.delete(jarToDelete);
                return EmptyResponseBody.getInstance();
            }
            catch (IOException e) {
                throw new CompletionException(new RestHandlerException(String.format("Failed to delete jar %s.", jarToDelete), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e));
            }
        }, this.executor);
    }
}

