/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.prometheus;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.flink.metrics.prometheus.PrometheusPushGatewayReporterOptions;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.shaded.io.prometheus.client.CollectorRegistry;
import org.apache.flink.shaded.io.prometheus.client.exporter.PushGateway;
import org.apache.flink.util.AbstractID;

@PublicEvolving
public class PrometheusPushGatewayReporter
extends AbstractPrometheusReporter
implements Scheduled {
    private PushGateway pushGateway;
    private String jobName;
    private boolean deleteOnShutdown;

    @Override
    public void open(MetricConfig config) {
        super.open(config);
        String host = config.getString(PrometheusPushGatewayReporterOptions.HOST.key(), (String)PrometheusPushGatewayReporterOptions.HOST.defaultValue());
        int port = config.getInteger(PrometheusPushGatewayReporterOptions.PORT.key(), ((Integer)PrometheusPushGatewayReporterOptions.PORT.defaultValue()).intValue());
        String configuredJobName = config.getString(PrometheusPushGatewayReporterOptions.JOB_NAME.key(), (String)PrometheusPushGatewayReporterOptions.JOB_NAME.defaultValue());
        boolean randomSuffix = config.getBoolean(PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.key(), ((Boolean)PrometheusPushGatewayReporterOptions.RANDOM_JOB_NAME_SUFFIX.defaultValue()).booleanValue());
        this.deleteOnShutdown = config.getBoolean(PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.key(), ((Boolean)PrometheusPushGatewayReporterOptions.DELETE_ON_SHUTDOWN.defaultValue()).booleanValue());
        if (host == null || host.isEmpty() || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        this.jobName = randomSuffix ? configuredJobName + new AbstractID() : configuredJobName;
        this.pushGateway = new PushGateway(host + ':' + port);
        this.log.info("Configured PrometheusPushGatewayReporter with {host:{}, port:{}, jobName: {}, randomJobNameSuffix:{}, deleteOnShutdown:{}}", new Object[]{host, port, this.jobName, randomSuffix, this.deleteOnShutdown});
    }

    public void report() {
        try {
            this.pushGateway.push(CollectorRegistry.defaultRegistry, this.jobName);
        }
        catch (Exception e) {
            this.log.warn("Failed to push metrics to PushGateway with jobName {}.", (Object)this.jobName, (Object)e);
        }
    }

    @Override
    public void close() {
        if (this.deleteOnShutdown && this.pushGateway != null) {
            try {
                this.pushGateway.delete(this.jobName);
            }
            catch (IOException e) {
                this.log.warn("Failed to delete metrics from PushGateway with jobName {}.", (Object)this.jobName, (Object)e);
            }
        }
        super.close();
    }
}

