/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.formats.json.JsonRowSchemaConverter;
import org.apache.flink.formats.json.TimeFormats;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingRuntimeException;

@PublicEvolving
public class JsonRowDeserializationSchema
implements DeserializationSchema<Row> {
    private static final long serialVersionUID = -228294330688809195L;
    private final RowTypeInfo typeInfo;
    private boolean failOnMissingField;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private DeserializationRuntimeConverter runtimeConverter;

    private JsonRowDeserializationSchema(TypeInformation<Row> typeInfo, boolean failOnMissingField) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information");
        Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
        this.typeInfo = (RowTypeInfo)typeInfo;
        this.failOnMissingField = failOnMissingField;
        this.runtimeConverter = this.createConverter((TypeInformation<?>)this.typeInfo);
    }

    @Deprecated
    public JsonRowDeserializationSchema(TypeInformation<Row> typeInfo) {
        this(typeInfo, false);
    }

    @Deprecated
    public JsonRowDeserializationSchema(String jsonSchema) {
        this(JsonRowSchemaConverter.convert((String)Preconditions.checkNotNull((Object)jsonSchema)), false);
    }

    @Deprecated
    public void setFailOnMissingField(boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
        this.runtimeConverter = this.createConverter((TypeInformation<?>)this.typeInfo);
    }

    public Row deserialize(byte[] message) throws IOException {
        try {
            JsonNode root = this.objectMapper.readTree(message);
            return (Row)this.runtimeConverter.convert(this.objectMapper, root);
        }
        catch (Throwable t) {
            throw new IOException("Failed to deserialize JSON object.", t);
        }
    }

    public boolean isEndOfStream(Row nextElement) {
        return false;
    }

    public TypeInformation<Row> getProducedType() {
        return this.typeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDeserializationSchema that = (JsonRowDeserializationSchema)o;
        return Objects.equals(this.typeInfo, that.typeInfo) && Objects.equals(this.failOnMissingField, that.failOnMissingField);
    }

    public int hashCode() {
        return Objects.hash(this.typeInfo, this.failOnMissingField);
    }

    private DeserializationRuntimeConverter createConverter(TypeInformation<?> typeInfo) {
        DeserializationRuntimeConverter baseConverter = this.createConverterForSimpleType(typeInfo).orElseGet(() -> this.createContainerConverter(typeInfo).orElseGet(() -> this.createFallbackConverter(typeInfo.getTypeClass())));
        return this.wrapIntoNullableConverter(baseConverter);
    }

    private DeserializationRuntimeConverter wrapIntoNullableConverter(DeserializationRuntimeConverter converter) {
        return (mapper, jsonNode) -> {
            if (jsonNode.isNull()) {
                return null;
            }
            return converter.convert(mapper, jsonNode);
        };
    }

    private Optional<DeserializationRuntimeConverter> createContainerConverter(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof RowTypeInfo) {
            return Optional.of(this.createRowConverter((RowTypeInfo)typeInfo));
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((ObjectArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return Optional.of(this.createObjectArrayConverter(((BasicArrayTypeInfo)typeInfo).getComponentInfo()));
        }
        if (this.isPrimitiveByteArray(typeInfo)) {
            return Optional.of(this.createByteArrayConverter());
        }
        if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            return Optional.of(this.createMapConverter(mapTypeInfo.getKeyTypeInfo(), mapTypeInfo.getValueTypeInfo()));
        }
        return Optional.empty();
    }

    private DeserializationRuntimeConverter createMapConverter(TypeInformation keyType, TypeInformation valueType) {
        DeserializationRuntimeConverter valueConverter = this.createConverter(valueType);
        DeserializationRuntimeConverter keyConverter = this.createConverter(keyType);
        return (mapper, jsonNode) -> {
            Iterator fields = jsonNode.fields();
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                Object key = keyConverter.convert(mapper, (JsonNode)TextNode.valueOf((String)((String)entry.getKey())));
                Object value = valueConverter.convert(mapper, (JsonNode)entry.getValue());
                result.put(key, value);
            }
            return result;
        };
    }

    private DeserializationRuntimeConverter createByteArrayConverter() {
        return (mapper, jsonNode) -> {
            try {
                return jsonNode.binaryValue();
            }
            catch (IOException e) {
                throw new WrappingRuntimeException("Unable to deserialize byte array.", (Throwable)e);
            }
        };
    }

    private boolean isPrimitiveByteArray(TypeInformation<?> typeInfo) {
        return typeInfo instanceof PrimitiveArrayTypeInfo && ((PrimitiveArrayTypeInfo)typeInfo).getComponentType() == Types.BYTE;
    }

    private DeserializationRuntimeConverter createObjectArrayConverter(TypeInformation elementTypeInfo) {
        DeserializationRuntimeConverter elementConverter = this.createConverter(elementTypeInfo);
        return this.assembleArrayConverter(elementTypeInfo, elementConverter);
    }

    private DeserializationRuntimeConverter createRowConverter(RowTypeInfo typeInfo) {
        List<DeserializationRuntimeConverter> fieldConverters = Arrays.stream(typeInfo.getFieldTypes()).map(this::createConverter).collect(Collectors.toList());
        return this.assembleRowConverter(typeInfo.getFieldNames(), fieldConverters);
    }

    private DeserializationRuntimeConverter createFallbackConverter(Class<?> valueType) {
        return (mapper, jsonNode) -> {
            try {
                return mapper.treeToValue((TreeNode)jsonNode, valueType);
            }
            catch (JsonProcessingException e) {
                throw new WrappingRuntimeException(String.format("Could not convert node: %s", jsonNode), (Throwable)e);
            }
        };
    }

    private Optional<DeserializationRuntimeConverter> createConverterForSimpleType(TypeInformation<?> simpleTypeInfo) {
        if (simpleTypeInfo == Types.VOID) {
            return Optional.of((mapper, jsonNode) -> null);
        }
        if (simpleTypeInfo == Types.BOOLEAN) {
            return Optional.of((mapper, jsonNode) -> jsonNode.asBoolean());
        }
        if (simpleTypeInfo == Types.STRING) {
            return Optional.of((mapper, jsonNode) -> jsonNode.asText());
        }
        if (simpleTypeInfo == Types.INT) {
            return Optional.of((mapper, jsonNode) -> jsonNode.asInt());
        }
        if (simpleTypeInfo == Types.LONG) {
            return Optional.of((mapper, jsonNode) -> jsonNode.asLong());
        }
        if (simpleTypeInfo == Types.DOUBLE) {
            return Optional.of((mapper, jsonNode) -> jsonNode.asDouble());
        }
        if (simpleTypeInfo == Types.FLOAT) {
            return Optional.of((mapper, jsonNode) -> Float.valueOf(Float.parseFloat(jsonNode.asText().trim())));
        }
        if (simpleTypeInfo == Types.SHORT) {
            return Optional.of((mapper, jsonNode) -> Short.parseShort(jsonNode.asText().trim()));
        }
        if (simpleTypeInfo == Types.BYTE) {
            return Optional.of((mapper, jsonNode) -> Byte.parseByte(jsonNode.asText().trim()));
        }
        if (simpleTypeInfo == Types.BIG_DEC) {
            return Optional.of((mapper, jsonNode) -> jsonNode.decimalValue());
        }
        if (simpleTypeInfo == Types.BIG_INT) {
            return Optional.of((mapper, jsonNode) -> jsonNode.bigIntegerValue());
        }
        if (simpleTypeInfo == Types.SQL_DATE) {
            return Optional.of(this::convertToDate);
        }
        if (simpleTypeInfo == Types.SQL_TIME) {
            return Optional.of(this::convertToTime);
        }
        if (simpleTypeInfo == Types.SQL_TIMESTAMP) {
            return Optional.of(this::convertToTimestamp);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE) {
            return Optional.of(this::convertToLocalDate);
        }
        if (simpleTypeInfo == Types.LOCAL_TIME) {
            return Optional.of(this::convertToLocalTime);
        }
        if (simpleTypeInfo == Types.LOCAL_DATE_TIME) {
            return Optional.of(this::convertToLocalDateTime);
        }
        return Optional.empty();
    }

    private LocalDate convertToLocalDate(ObjectMapper mapper, JsonNode jsonNode) {
        return DateTimeFormatter.ISO_LOCAL_DATE.parse(jsonNode.asText()).query(TemporalQueries.localDate());
    }

    private Date convertToDate(ObjectMapper mapper, JsonNode jsonNode) {
        return Date.valueOf(this.convertToLocalDate(mapper, jsonNode));
    }

    private LocalDateTime convertToLocalDateTime(ObjectMapper mapper, JsonNode jsonNode) {
        TemporalAccessor parsedTimestamp = TimeFormats.RFC3339_TIMESTAMP_FORMAT.parse(jsonNode.asText());
        ZoneOffset zoneOffset = parsedTimestamp.query(TemporalQueries.offset());
        if (zoneOffset != null && zoneOffset.getTotalSeconds() != 0) {
            throw new IllegalStateException("Invalid timestamp format. Only a timestamp in UTC timezone is supported yet. Format: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
        LocalTime localTime = parsedTimestamp.query(TemporalQueries.localTime());
        LocalDate localDate = parsedTimestamp.query(TemporalQueries.localDate());
        return LocalDateTime.of(localDate, localTime);
    }

    private Timestamp convertToTimestamp(ObjectMapper mapper, JsonNode jsonNode) {
        return Timestamp.valueOf(this.convertToLocalDateTime(mapper, jsonNode));
    }

    private LocalTime convertToLocalTime(ObjectMapper mapper, JsonNode jsonNode) {
        TemporalAccessor parsedTime = TimeFormats.RFC3339_TIME_FORMAT.parse(jsonNode.asText());
        ZoneOffset zoneOffset = parsedTime.query(TemporalQueries.offset());
        LocalTime localTime = parsedTime.query(TemporalQueries.localTime());
        if (zoneOffset != null && zoneOffset.getTotalSeconds() != 0 || localTime.getNano() != 0) {
            throw new IllegalStateException("Invalid time format. Only a time in UTC timezone without milliseconds is supported yet.");
        }
        return localTime;
    }

    private Time convertToTime(ObjectMapper mapper, JsonNode jsonNode) {
        return Time.valueOf(this.convertToLocalTime(mapper, jsonNode));
    }

    private DeserializationRuntimeConverter assembleRowConverter(String[] fieldNames, List<DeserializationRuntimeConverter> fieldConverters) {
        return (mapper, jsonNode) -> {
            ObjectNode node = (ObjectNode)jsonNode;
            int arity = fieldNames.length;
            Row row = new Row(arity);
            for (int i = 0; i < arity; ++i) {
                String fieldName = fieldNames[i];
                JsonNode field = node.get(fieldName);
                Object convertField = this.convertField(mapper, (DeserializationRuntimeConverter)fieldConverters.get(i), fieldName, field);
                row.setField(i, convertField);
            }
            return row;
        };
    }

    private Object convertField(ObjectMapper mapper, DeserializationRuntimeConverter fieldConverter, String fieldName, JsonNode field) {
        if (field == null) {
            if (this.failOnMissingField) {
                throw new IllegalStateException("Could not find field with name '" + fieldName + "'.");
            }
            return null;
        }
        return fieldConverter.convert(mapper, field);
    }

    private DeserializationRuntimeConverter assembleArrayConverter(TypeInformation<?> elementType, DeserializationRuntimeConverter elementConverter) {
        Class elementClass = elementType.getTypeClass();
        return (mapper, jsonNode) -> {
            ArrayNode node = (ArrayNode)jsonNode;
            Object[] array = (Object[])Array.newInstance(elementClass, node.size());
            for (int i = 0; i < node.size(); ++i) {
                JsonNode innerNode = node.get(i);
                array[i] = elementConverter.convert(mapper, innerNode);
            }
            return array;
        };
    }

    @FunctionalInterface
    private static interface DeserializationRuntimeConverter
    extends Serializable {
        public Object convert(ObjectMapper var1, JsonNode var2);
    }

    public static class Builder {
        private final RowTypeInfo typeInfo;
        private boolean failOnMissingField = false;

        public Builder(TypeInformation<Row> typeInfo) {
            Preconditions.checkArgument((boolean)(typeInfo instanceof RowTypeInfo), (Object)"Only RowTypeInfo is supported");
            this.typeInfo = (RowTypeInfo)typeInfo;
        }

        public Builder(String jsonSchema) {
            this(JsonRowSchemaConverter.convert((String)Preconditions.checkNotNull((Object)jsonSchema)));
        }

        public Builder failOnMissingField() {
            this.failOnMissingField = true;
            return this;
        }

        public JsonRowDeserializationSchema build() {
            return new JsonRowDeserializationSchema((TypeInformation)this.typeInfo, this.failOnMissingField);
        }
    }
}

