/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;

public final class AnnotationMeta<A extends Annotation> {
    private final Map<String, Optional<Object>> cache = CollectionUtils.newConcurrentHashMap();
    private final AnnotatedElement element;
    private final A annotation;
    private final RestToolKit toolKit;
    private Map<String, Object> attributes;

    public AnnotationMeta(AnnotatedElement element, A annotation, RestToolKit toolKit) {
        this.element = element;
        this.annotation = annotation;
        this.toolKit = toolKit;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotation.annotationType();
    }

    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = this.attributes;
        if (attributes == null) {
            Map<String, Object> map = this.toolKit.getAttributes(this.element, (Annotation)this.annotation);
            if (CollectionUtils.isEmptyMap(map)) {
                attributes = Collections.emptyMap();
            } else {
                attributes = CollectionUtils.newHashMap((int)map.size());
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        value = this.toolKit.resolvePlaceholders((String)value);
                    } else if (value instanceof String[]) {
                        String[] array = (String[])value;
                        int len = array.length;
                        for (int i = 0; i < len; ++i) {
                            array[i] = this.toolKit.resolvePlaceholders(array[i]);
                        }
                    }
                    attributes.put(entry.getKey(), value);
                }
            }
            this.attributes = attributes;
        }
        return attributes;
    }

    public boolean hasAttribute(String attributeName) {
        return this.getAttributes().containsKey(attributeName);
    }

    public String getValue() {
        return this.getString("value");
    }

    public String[] getValueArray() {
        return this.getStringArray("value");
    }

    public String getString(String attributeName) {
        return this.getRequiredAttribute(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getRequiredAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getRequiredAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getRequiredAttribute(attributeName, Enum.class);
    }

    public <E extends Enum<?>> E[] getEnumArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Enum[].class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class[].class);
    }

    public <A1 extends Annotation> AnnotationMeta<A1> getAnnotation(String attributeName) {
        return (AnnotationMeta)this.cache.computeIfAbsent(attributeName, k -> {
            if (this.getAttributes().get(attributeName) == null) {
                return Optional.empty();
            }
            Annotation annotation = this.getRequiredAttribute(attributeName, Annotation.class);
            return Optional.of(new AnnotationMeta<Annotation>(this.getAnnotationType(), annotation, this.toolKit));
        }).orElseThrow(() -> this.attributeNotFound(attributeName));
    }

    public <A1 extends Annotation> AnnotationMeta<A1>[] getAnnotationArray(String attributeName) {
        return (AnnotationMeta[])this.cache.computeIfAbsent(attributeName, k -> {
            if (this.getAttributes().get(attributeName) == null) {
                return Optional.empty();
            }
            Annotation[] annotation = this.getRequiredAttribute(attributeName, Annotation[].class);
            int len = annotation.length;
            AnnotationMeta[] metas = new AnnotationMeta[len];
            for (int i = 0; i < len; ++i) {
                metas[i] = new AnnotationMeta<Annotation>(this.getAnnotationType(), annotation[i], this.toolKit);
            }
            return Optional.of(metas);
        }).orElseThrow(() -> this.attributeNotFound(attributeName));
    }

    public <A1 extends Annotation> A1 getAnnotation(String attributeName, Class<A1> annotationType) {
        return (A1)((Annotation)this.getRequiredAttribute(attributeName, annotationType));
    }

    public <A1 extends Annotation> A1[] getAnnotationArray(String attributeName, Class<A1> annotationType) {
        Class<?> arrayType = Array.newInstance(annotationType, 0).getClass();
        return (Annotation[])this.getRequiredAttribute(attributeName, arrayType);
    }

    public <T> T getRequiredAttribute(String attributeName, Class<T> expectedType) {
        Object value = this.getAttributes().get(attributeName);
        if (value == null) {
            throw this.attributeNotFound(attributeName);
        }
        if (value instanceof Throwable) {
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", attributeName, this.getAnnotationType().getName(), value), (Throwable)value);
        }
        if (expectedType.isInstance(value)) {
            return (T)value;
        }
        if (expectedType == String.class) {
            return (T)value.toString();
        }
        if (expectedType == Boolean.class) {
            Boolean b = StringUtils.toBoolean((String)value.toString());
            return (T)(b == null ? Boolean.FALSE : b);
        }
        if (expectedType == Number.class) {
            String str = value.toString();
            return (T)(str.indexOf(46) > -1 ? (Number)Double.valueOf(str) : (Number)Long.valueOf(str));
        }
        if (expectedType.isArray()) {
            Class<?> expectedComponentType = expectedType.getComponentType();
            if (expectedComponentType.isInstance(value)) {
                Object array = Array.newInstance(expectedComponentType, 1);
                Array.set(array, 0, value);
                return (T)array;
            }
            if (expectedComponentType == String.class) {
                String[] array;
                if (value.getClass().isArray()) {
                    int len = Array.getLength(value);
                    array = new String[len];
                    for (int i = 0; i < len; ++i) {
                        array[i] = Array.get(value, i).toString();
                    }
                } else {
                    array = new String[]{value.toString()};
                }
                return (T)array;
            }
        }
        throw new IllegalArgumentException(String.format("Attribute '%s' is of type %s, but %s was expected in attributes for annotation [%s]", attributeName, value.getClass().getSimpleName(), expectedType.getSimpleName(), this.getAnnotationType().getName()));
    }

    private IllegalArgumentException attributeNotFound(String attributeName) {
        return new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.getAnnotationType().getName()));
    }

    public int hashCode() {
        return 31 * this.element.hashCode() + this.annotation.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != AnnotationMeta.class) {
            return false;
        }
        AnnotationMeta other = (AnnotationMeta)obj;
        return this.element.equals(other.element) && this.annotation.equals(other.annotation);
    }

    public String toString() {
        return "AnnotationMeta{element=" + this.element + ", annotation=" + this.annotation + '}';
    }
}

