/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.rpc.protocol.tri.rest.Messages;
import org.apache.dubbo.rpc.protocol.tri.rest.PathParserException;
import org.apache.dubbo.rpc.protocol.tri.rest.util.KeyString;

public final class PathSegment
implements Comparable<PathSegment> {
    private Type type;
    private String value;
    private List<String> variables;
    private Pattern pattern;
    private KeyString keyValue;

    public PathSegment(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public PathSegment(Type type, String value, String variable) {
        this.type = type;
        this.value = value;
        this.addVariable(variable);
    }

    public static PathSegment literal(String value) {
        return new PathSegment(Type.LITERAL, value);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public void setVariables(List<String> variables) {
        this.variables = variables;
    }

    public String getVariable() {
        return this.variables.get(0);
    }

    public void addVariable(String variable) {
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        } else if (this.variables.contains(variable)) {
            throw new PathParserException(Messages.DUPLICATE_CAPTURE_VARIABLE, variable);
        }
        this.variables.add(variable);
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.initPattern();
        }
        return this.pattern;
    }

    public void initPattern() {
        if (this.isPattern()) {
            this.pattern = Pattern.compile(this.value);
        }
    }

    public boolean isPattern() {
        return this.type == Type.PATTERN || this.type == Type.PATTERN_MULTI;
    }

    public boolean isTailMatching() {
        return this.type == Type.WILDCARD_TAIL || this.type == Type.PATTERN_MULTI;
    }

    public boolean match(KeyString path, int start, int end, Map<String, String> variableMap) {
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                if (this.keyValue == null) {
                    this.keyValue = new KeyString(this.value);
                }
                return path.regionMatches(start, this.keyValue);
            }
            case 3: {
                if (this.variables != null) {
                    variableMap.put(this.getVariable(), path.toString(start));
                }
                return true;
            }
            case 4: {
                if (this.variables != null) {
                    variableMap.put(this.getVariable(), path.toString(start, end));
                }
                return true;
            }
            case 5: {
                return this.matchPattern(path.toString(start, end), variableMap);
            }
            case 6: {
                return this.matchPattern(path.toString(start), variableMap);
            }
        }
        return false;
    }

    public boolean match(String path, int start, int end, Map<String, String> variableMap) {
        return this.match(new KeyString(path), start, end, variableMap);
    }

    private boolean matchPattern(String path, Map<String, String> variableMap) {
        Matcher matcher = this.getPattern().matcher(path);
        if (matcher.matches()) {
            if (this.variables == null) {
                return true;
            }
            int size = this.variables.size();
            for (int i = 0; i < size; ++i) {
                String variable = this.variables.get(i);
                variableMap.put(variable, matcher.group(variable));
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.type.ordinal() | (this.value == null ? 0 : this.value.hashCode() << 3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != PathSegment.class) {
            return false;
        }
        PathSegment that = (PathSegment)obj;
        return this.type == that.type && this.value.equals(that.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{type=");
        sb.append((Object)this.type);
        if (this.value != null) {
            sb.append(", value=").append(this.value);
        }
        if (this.variables != null) {
            sb.append(", variables=").append(this.variables);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(PathSegment other) {
        int comparison;
        if (this.type != other.type && (comparison = this.type.score() - other.type.score) != 0) {
            return comparison;
        }
        int size = this.variables == null ? 99 : this.variables.size();
        int otherSize = other.variables == null ? 99 : other.variables.size();
        return size - otherSize;
    }

    public static enum Type {
        SLASH,
        LITERAL(1),
        WILDCARD,
        WILDCARD_TAIL,
        VARIABLE(10),
        PATTERN(100),
        PATTERN_MULTI(200);

        private final int score;

        private Type(int score) {
            this.score = score;
        }

        private Type() {
            this.score = 10000;
        }

        public int score() {
            return this.score;
        }
    }
}

