/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class NacosRegistry
extends FailbackRegistry {
    private static final String[] ALL_SUPPORTED_CATEGORIES = NacosRegistry.of("providers", "consumers", "routers", "configurators");
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private static final String WILDCARD = "*";
    private static final String SERVICE_NAME_SEPARATOR = System.getProperty("nacos.service.name.separator", ":");
    private static final int PAGINATION_SIZE = Integer.getInteger("nacos.service.names.pagination.size", 100);
    private static final long LOOKUP_INTERVAL = Long.getLong("nacos.service.names.lookup.interval", 30L);
    private volatile ScheduledExecutorService scheduledExecutorService;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NamingService namingService;
    private final ConcurrentMap<String, EventListener> nacosListeners;

    public NacosRegistry(URL url, NamingService namingService) {
        super(url);
        this.namingService = namingService;
        this.nacosListeners = new ConcurrentHashMap<String, EventListener>();
    }

    public boolean isAvailable() {
        return "UP".equals(this.namingService.getServerStatus());
    }

    public List<URL> lookup(final URL url) {
        final LinkedList<URL> urls = new LinkedList<URL>();
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                List serviceNames = NacosRegistry.this.getServiceNames(url, null);
                for (String serviceName : serviceNames) {
                    List instances = namingService.getAllInstances(serviceName);
                    urls.addAll(NacosRegistry.this.buildURLs(url, instances));
                }
            }
        });
        return urls;
    }

    public void doRegister(URL url) {
        final String serviceName = this.getServiceName(url);
        final Instance instance = this.createInstance(url);
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                namingService.registerInstance(serviceName, instance);
            }
        });
    }

    public void doUnregister(final URL url) {
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                String serviceName = NacosRegistry.this.getServiceName(url);
                Instance instance = NacosRegistry.this.createInstance(url);
                namingService.deregisterInstance(serviceName, instance.getIp(), instance.getPort());
            }
        });
    }

    public void doSubscribe(URL url, NotifyListener listener) {
        List<String> serviceNames = this.getServiceNames(url, listener);
        this.doSubscribe(url, listener, serviceNames);
    }

    private void doSubscribe(final URL url, final NotifyListener listener, final List<String> serviceNames) {
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                for (String serviceName : serviceNames) {
                    List instances = namingService.getAllInstances(serviceName);
                    NacosRegistry.this.notifySubscriber(url, listener, instances);
                    NacosRegistry.this.subscribeEventListener(serviceName, url, listener);
                }
            }
        });
    }

    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.shutdownServiceNamesLookup();
        }
    }

    private void shutdownServiceNamesLookup() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    private List<String> getServiceNames(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.scheduleServiceNamesLookup(url, listener);
            return this.getServiceNamesForOps(url);
        }
        return this.doGetServiceNames(url);
    }

    private boolean isAdminProtocol(URL url) {
        return "admin".equals(url.getProtocol());
    }

    private void scheduleServiceNamesLookup(final URL url, final NotifyListener listener) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    List serviceNames = NacosRegistry.this.getAllServiceNames();
                    NacosRegistry.this.filterData(serviceNames, new NacosDataFilter<String>(){

                        @Override
                        public boolean accept(String serviceName) {
                            boolean accepted = false;
                            for (String category : ALL_SUPPORTED_CATEGORIES) {
                                String prefix = category + SERVICE_NAME_SEPARATOR;
                                if (!StringUtils.startsWith((CharSequence)serviceName, (CharSequence)prefix)) continue;
                                accepted = true;
                                break;
                            }
                            return accepted;
                        }
                    });
                    NacosRegistry.this.doSubscribe(url, listener, serviceNames);
                }
            }, LOOKUP_INTERVAL, LOOKUP_INTERVAL, TimeUnit.SECONDS);
        }
    }

    private List<String> getServiceNamesForOps(URL url) {
        List<String> serviceNames = this.getAllServiceNames();
        this.filterServiceNames(serviceNames, url);
        return serviceNames;
    }

    private List<String> getAllServiceNames() {
        final LinkedList<String> serviceNames = new LinkedList<String>();
        this.execute(new NamingServiceCallback(){

            @Override
            public void callback(NamingService namingService) throws NacosException {
                int pageIndex = 1;
                ListView listView = namingService.getServicesOfServer(pageIndex, PAGINATION_SIZE);
                List firstPageData = listView.getData();
                serviceNames.addAll(firstPageData);
                int count = listView.getCount();
                int pageNumbers = count / PAGINATION_SIZE;
                int remainder = count % PAGINATION_SIZE;
                if (remainder > 0) {
                    ++pageNumbers;
                }
                while (pageIndex < pageNumbers) {
                    listView = namingService.getServicesOfServer(++pageIndex, PAGINATION_SIZE);
                    serviceNames.addAll(listView.getData());
                }
            }
        });
        return serviceNames;
    }

    private void filterServiceNames(List<String> serviceNames, URL url) {
        final String[] categories = this.getCategories(url);
        final String targetServiceInterface = url.getServiceInterface();
        final String targetVersion = url.getParameter("version");
        final String targetGroup = url.getParameter("group");
        this.filterData(serviceNames, new NacosDataFilter<String>(){

            @Override
            public boolean accept(String serviceName) {
                String group;
                String[] segments = StringUtils.split((String)serviceName, (String)SERVICE_NAME_SEPARATOR);
                int length = segments.length;
                if (length < 3) {
                    return false;
                }
                String category = segments[0];
                if (!ArrayUtils.contains((Object[])categories, (Object)category)) {
                    return false;
                }
                String serviceInterface = segments[1];
                if (!NacosRegistry.WILDCARD.equals(targetServiceInterface) && !StringUtils.equals((CharSequence)targetServiceInterface, (CharSequence)serviceInterface)) {
                    return false;
                }
                String version = segments[2];
                if (!NacosRegistry.WILDCARD.equals(targetVersion) && !StringUtils.equals((CharSequence)targetVersion, (CharSequence)version)) {
                    return false;
                }
                String string = group = length > 3 ? segments[3] : null;
                return group == null || NacosRegistry.WILDCARD.equals(targetGroup) || StringUtils.equals((CharSequence)targetGroup, (CharSequence)group);
            }
        });
    }

    private <T> void filterData(Collection<T> collection, NacosDataFilter<T> filter) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T data = iterator.next();
            if (filter.accept(data)) continue;
            iterator.remove();
        }
    }

    private List<String> doGetServiceNames(URL url) {
        String[] categories = this.getCategories(url);
        ArrayList<String> serviceNames = new ArrayList<String>(categories.length);
        for (String category : categories) {
            String serviceName = this.getServiceName(url, category);
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    private List<URL> buildURLs(URL consumerURL, Collection<Instance> instances) {
        if (instances.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<URL> urls = new LinkedList<URL>();
        for (Instance instance : instances) {
            URL url = this.buildURL(instance);
            if (!UrlUtils.isMatch((URL)consumerURL, (URL)url)) continue;
            urls.add(url);
        }
        return urls;
    }

    private void subscribeEventListener(String serviceName, final URL url, final NotifyListener listener) throws NacosException {
        if (!this.nacosListeners.containsKey(serviceName)) {
            EventListener eventListener = new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        NamingEvent e = (NamingEvent)event;
                        NacosRegistry.this.notifySubscriber(url, listener, e.getInstances());
                    }
                }
            };
            this.namingService.subscribe(serviceName, eventListener);
            this.nacosListeners.put(serviceName, eventListener);
        }
    }

    private void notifySubscriber(URL url, NotifyListener listener, Collection<Instance> instances) {
        LinkedList<Instance> healthyInstances = new LinkedList<Instance>(instances);
        this.filterHealthyInstances(healthyInstances);
        List<URL> urls = this.buildURLs(url, healthyInstances);
        this.notify(url, listener, urls);
    }

    private String[] getCategories(URL url) {
        return WILDCARD.equals(url.getServiceInterface()) ? ALL_SUPPORTED_CATEGORIES : NacosRegistry.of("providers");
    }

    private URL buildURL(Instance instance) {
        Map metadata = instance.getMetadata();
        String protocol = (String)metadata.get("protocol");
        String path = (String)metadata.get("path");
        URL url = new URL(protocol, instance.getIp(), instance.getPort(), path, instance.getMetadata());
        return url;
    }

    private Instance createInstance(URL url) {
        String category = url.getParameter("category", "providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        newURL = newURL.addParameter("path", url.getPath());
        String ip = url.getHost();
        int port = url.getPort();
        Instance instance = new Instance();
        instance.setIp(ip);
        instance.setPort(port);
        instance.setMetadata(new HashMap(newURL.getParameters()));
        return instance;
    }

    private String getServiceName(URL url) {
        String category = url.getParameter("category", "providers");
        return this.getServiceName(url, category);
    }

    private String getServiceName(URL url, String category) {
        StringBuilder serviceNameBuilder = new StringBuilder(category);
        this.appendIfPresent(serviceNameBuilder, url, "interface");
        this.appendIfPresent(serviceNameBuilder, url, "version");
        this.appendIfPresent(serviceNameBuilder, url, "group");
        return serviceNameBuilder.toString();
    }

    private void appendIfPresent(StringBuilder target, URL url, String parameterName) {
        String parameterValue = url.getParameter(parameterName);
        if (!StringUtils.isBlank((CharSequence)parameterValue)) {
            target.append(SERVICE_NAME_SEPARATOR).append(parameterValue);
        }
    }

    private void execute(NamingServiceCallback callback) {
        block2: {
            try {
                callback.callback(this.namingService);
            }
            catch (NacosException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
        }
    }

    private void filterHealthyInstances(Collection<Instance> instances) {
        this.filterData(instances, new NacosDataFilter<Instance>(){

            @Override
            public boolean accept(Instance data) {
                return data.isEnabled();
            }
        });
    }

    private static <T> T[] of(T ... values) {
        return values;
    }

    static interface NamingServiceCallback {
        public void callback(NamingService var1) throws NacosException;
    }

    private static interface NacosDataFilter<T> {
        public boolean accept(T var1);
    }
}

