/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.json.JsonUtil;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class JsonUtils {
    private static volatile JsonUtil jsonUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonUtil getJson() {
        if (jsonUtil != null) return jsonUtil;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (jsonUtil != null) return jsonUtil;
            jsonUtil = JsonUtils.createJsonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jsonUtil;
        }
    }

    private static JsonUtil createJsonUtil() {
        ClassLoader classLoader;
        HashMap<String, JsonUtil> extensions = new HashMap<String, JsonUtil>();
        String preferName = SystemPropertyConfigUtils.getSystemProperty("dubbo.json-framework.prefer");
        JsonUtil jsonUtil = JsonUtils.loadExtensions(preferName, classLoader = JsonUtil.class.getClassLoader(), extensions);
        if (jsonUtil != null) {
            return jsonUtil;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null && tccl != classLoader && (jsonUtil = JsonUtils.loadExtensions(preferName, classLoader, extensions)) != null) {
            return jsonUtil;
        }
        TreeMap<Integer, JsonUtil> sortedExtensions = new TreeMap<Integer, JsonUtil>();
        for (JsonUtil extension : extensions.values()) {
            Activate activate = extension.getClass().getAnnotation(Activate.class);
            sortedExtensions.put(activate == null ? 0 : activate.order(), extension);
        }
        if (sortedExtensions.isEmpty()) {
            throw new IllegalStateException("Dubbo unable to find out any json framework (e.g. fastjson2, fastjson, gson, jackson) from jvm env. Please import at least one json framework.");
        }
        return (JsonUtil)sortedExtensions.firstEntry().getValue();
    }

    private static JsonUtil loadExtensions(String name, ClassLoader classLoader, Map<String, JsonUtil> extensions) {
        ServiceLoader<JsonUtil> loader = ServiceLoader.load(JsonUtil.class, classLoader);
        Iterator<JsonUtil> it = loader.iterator();
        while (it.hasNext()) {
            try {
                JsonUtil extension = it.next();
                if (!extension.isSupport()) continue;
                if (name != null && name.equals(extension.getName())) {
                    return extension;
                }
                extensions.put(extension.getName(), extension);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @Deprecated
    protected static void setJson(JsonUtil json) {
        jsonUtil = json;
    }

    public static <T> T toJavaObject(String json, Type type) {
        return JsonUtils.getJson().toJavaObject(json, type);
    }

    public static <T> List<T> toJavaList(String json, Class<T> clazz) {
        return JsonUtils.getJson().toJavaList(json, clazz);
    }

    public static String toJson(Object obj) {
        return JsonUtils.getJson().toJson(obj);
    }

    public static String toPrettyJson(Object obj) {
        return JsonUtils.getJson().toPrettyJson(obj);
    }

    public static List<?> getList(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getList(obj, key);
    }

    public static List<Map<String, ?>> getListOfObjects(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfObjects(obj, key);
    }

    public static List<String> getListOfStrings(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getListOfStrings(obj, key);
    }

    public static Map<String, ?> getObject(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getObject(obj, key);
    }

    public static Object convertObject(Object obj, Type targetType) {
        return JsonUtils.getJson().convertObject(obj, targetType);
    }

    public static Object convertObject(Object obj, Class<?> targetType) {
        return JsonUtils.getJson().convertObject(obj, targetType);
    }

    public static Double getNumberAsDouble(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsDouble(obj, key);
    }

    public static Integer getNumberAsInteger(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsInteger(obj, key);
    }

    public static Long getNumberAsLong(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getNumberAsLong(obj, key);
    }

    public static String getString(Map<String, ?> obj, String key) {
        return JsonUtils.getJson().getString(obj, key);
    }

    public static List<Map<String, ?>> checkObjectList(List<?> rawList) {
        return JsonUtils.getJson().checkObjectList(rawList);
    }

    public static List<String> checkStringList(List<?> rawList) {
        return JsonUtils.getJson().checkStringList(rawList);
    }

    public static boolean checkJson(String json) {
        return JsonUtils.getJson().isJson(json);
    }
}

