/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.rpc.executor.DefaultExecutorSupport;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceModel;

public class DefaultExecutorRepository
implements ExecutorRepository,
ExtensionAccessorAware {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultExecutorRepository.class);
    private static final String MAX_KEY = String.valueOf(Integer.MAX_VALUE);
    private volatile ScheduledExecutorService serviceExportExecutor;
    private volatile ExecutorService serviceReferExecutor;
    private final ConcurrentMap<String, ConcurrentMap<String, ExecutorService>> data = new ConcurrentHashMap<String, ConcurrentMap<String, ExecutorService>>();
    private final Object LOCK = new Object();
    private ExtensionAccessor extensionAccessor;
    private final ApplicationModel applicationModel;
    private final FrameworkExecutorRepository frameworkExecutorRepository;
    private ExecutorSupport executorSupport;
    private final DataStore dataStore;

    public DefaultExecutorRepository(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        this.frameworkExecutorRepository = applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
        this.dataStore = applicationModel.getExtensionLoader(DataStore.class).getDefaultExtension();
    }

    @Override
    public synchronized ExecutorService createExecutorIfAbsent(URL url) {
        String executorKey = this.getExecutorKey(url);
        ConcurrentMap executors = ConcurrentHashMapUtils.computeIfAbsent(this.data, executorKey, k -> new ConcurrentHashMap());
        String executorCacheKey = this.getExecutorSecondKey(url);
        URL finalUrl = url = this.setThreadNameIfAbsent(url, executorCacheKey);
        ExecutorService executor = ConcurrentHashMapUtils.computeIfAbsent(executors, executorCacheKey, k -> this.createExecutor(finalUrl));
        if (executor.isShutdown() || executor.isTerminated()) {
            executors.remove(executorCacheKey);
            executor = this.createExecutor(url);
            executors.put(executorCacheKey, executor);
        }
        this.dataStore.put(executorKey, executorCacheKey, executor);
        return executor;
    }

    protected URL setThreadNameIfAbsent(URL url, String executorCacheKey) {
        if (url.getParameter("threadname") == null) {
            String protocol = url.getProtocol();
            if (StringUtils.isEmpty(protocol)) {
                protocol = "dubbo";
            }
            url = url.putAttribute("threadname", protocol + "-protocol-" + executorCacheKey);
        }
        return url;
    }

    private String getExecutorSecondKey(URL url) {
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            return this.getConsumerKey(url);
        }
        return this.getProviderKey(url);
    }

    private String getExecutorSecondKey(ServiceModel serviceModel, URL url) {
        if (serviceModel instanceof ConsumerModel) {
            return this.getConsumerKey(serviceModel);
        }
        return this.getProviderKey((ProviderModel)serviceModel, url);
    }

    private String getConsumerKey(URL url) {
        return String.valueOf(Integer.MAX_VALUE);
    }

    private String getConsumerKey(ServiceModel serviceModel) {
        return MAX_KEY;
    }

    protected String getProviderKey(URL url) {
        return String.valueOf(url.getPort());
    }

    protected String getProviderKey(ProviderModel providerModel, URL url) {
        return String.valueOf(url.getPort());
    }

    private String getExecutorKey(URL url) {
        if ("consumer".equalsIgnoreCase(url.getParameter("side"))) {
            return "CONSUMER_SHARED_SERVICE_EXECUTOR";
        }
        return CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY;
    }

    private String getExecutorKey(ServiceModel serviceModel) {
        if (serviceModel instanceof ProviderModel) {
            return CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY;
        }
        return "CONSUMER_SHARED_SERVICE_EXECUTOR";
    }

    protected ExecutorService createExecutor(URL url) {
        return (ExecutorService)this.extensionAccessor.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }

    @Override
    public ExecutorService getExecutor(URL url) {
        Map executors = (Map)this.data.get(this.getExecutorKey(url));
        if (executors == null) {
            logger.warn("0-16", "", "", "No available executors, this is not expected, framework should call createExecutorIfAbsent firstbefore coming to here.");
            return null;
        }
        String executorCacheKey = this.getExecutorSecondKey(url);
        ExecutorService executor = (ExecutorService)executors.get(executorCacheKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(executorCacheKey);
            executor = null;
            logger.info("Executor for " + url + " is shutdown.");
        }
        if (executor == null) {
            return this.frameworkExecutorRepository.getSharedExecutor();
        }
        return executor;
    }

    @Override
    public ExecutorService getExecutor(ServiceModel serviceModel, URL url) {
        Map executors = (Map)this.data.get(this.getExecutorKey(serviceModel));
        if (executors == null) {
            logger.warn("0-16", "", "", "No available executors, this is not expected, framework should call createExecutorIfAbsent firstbefore coming to here.");
            return null;
        }
        String executorCacheKey = this.getExecutorSecondKey(serviceModel, url);
        ExecutorService executor = (ExecutorService)executors.get(executorCacheKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(executorCacheKey);
            executor = null;
            logger.info("Executor for " + url + " is shutdown.");
        }
        if (executor == null) {
            return this.frameworkExecutorRepository.getSharedExecutor();
        }
        return executor;
    }

    @Override
    public void updateThreadpool(URL url, ExecutorService executor) {
        try {
            if (url.hasParameter("threads") && executor instanceof ThreadPoolExecutor && !executor.isShutdown()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                int threads = url.getParameter("threads", 0);
                int max = threadPoolExecutor.getMaximumPoolSize();
                int core = threadPoolExecutor.getCorePoolSize();
                if (threads > 0 && (threads != max || threads != core)) {
                    if (threads < core) {
                        threadPoolExecutor.setCorePoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setMaximumPoolSize(threads);
                        }
                    } else {
                        threadPoolExecutor.setMaximumPoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setCorePoolSize(threads);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("0-18", "", "", t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getServiceExportExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceExportExecutor == null) {
                int coreSize = this.getExportThreadNum();
                String applicationName = this.applicationModel.tryGetApplicationName();
                applicationName = StringUtils.isEmpty(applicationName) ? "app" : applicationName;
                this.serviceExportExecutor = Executors.newScheduledThreadPool(coreSize, new NamedThreadFactory("Dubbo-" + applicationName + "-service-export", true));
            }
        }
        return this.serviceExportExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceExportExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceExportExecutor != null && !this.serviceExportExecutor.isShutdown()) {
                try {
                    this.serviceExportExecutor.shutdown();
                }
                catch (Throwable ignored) {
                    logger.warn("0-17", "", "", ignored.getMessage(), ignored);
                }
            }
            this.serviceExportExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getServiceReferExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceReferExecutor == null) {
                int coreSize = this.getReferThreadNum();
                String applicationName = this.applicationModel.tryGetApplicationName();
                applicationName = StringUtils.isEmpty(applicationName) ? "app" : applicationName;
                this.serviceReferExecutor = Executors.newFixedThreadPool(coreSize, new NamedThreadFactory("Dubbo-" + applicationName + "-service-refer", true));
            }
        }
        return this.serviceReferExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceReferExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceReferExecutor != null && !this.serviceReferExecutor.isShutdown()) {
                try {
                    this.serviceReferExecutor.shutdown();
                }
                catch (Throwable ignored) {
                    logger.warn("0-17", "", "", ignored.getMessage(), ignored);
                }
            }
            this.serviceReferExecutor = null;
        }
    }

    private Integer getExportThreadNum() {
        ModuleModel moduleModel;
        Integer threadNum = null;
        ApplicationModel applicationModel = ApplicationModel.ofNullable(this.applicationModel);
        Iterator<ModuleModel> iterator = applicationModel.getPubModuleModels().iterator();
        while (iterator.hasNext() && (threadNum = this.getExportThreadNum(moduleModel = iterator.next())) == null) {
        }
        if (threadNum == null) {
            logger.info("Cannot get config `export-thread-num` from module config, using default: 10");
            return 10;
        }
        return threadNum;
    }

    private Integer getExportThreadNum(ModuleModel moduleModel) {
        ModuleConfig moduleConfig = moduleModel.getConfigManager().getModule().orElse(null);
        if (moduleConfig == null) {
            return null;
        }
        Integer threadNum = moduleConfig.getExportThreadNum();
        if (threadNum == null) {
            threadNum = moduleModel.getConfigManager().getProviders().stream().map(ProviderConfig::getExportThreadNum).filter(k -> k != null && k > 0).findAny().orElse(null);
        }
        return threadNum;
    }

    private Integer getReferThreadNum() {
        ModuleModel moduleModel;
        Integer threadNum = null;
        ApplicationModel applicationModel = ApplicationModel.ofNullable(this.applicationModel);
        Iterator<ModuleModel> iterator = applicationModel.getPubModuleModels().iterator();
        while (iterator.hasNext() && (threadNum = this.getReferThreadNum(moduleModel = iterator.next())) == null) {
        }
        if (threadNum == null) {
            logger.info("Cannot get config `refer-thread-num` from module config, using default: 10");
            return 10;
        }
        return threadNum;
    }

    private Integer getReferThreadNum(ModuleModel moduleModel) {
        ModuleConfig moduleConfig = moduleModel.getConfigManager().getModule().orElse(null);
        if (moduleConfig == null) {
            return null;
        }
        Integer threadNum = moduleConfig.getReferThreadNum();
        if (threadNum == null) {
            threadNum = moduleModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getReferThreadNum).filter(k -> k != null && k > 0).findAny().orElse(null);
        }
        return threadNum;
    }

    @Override
    public void destroyAll() {
        logger.info("destroying application executor repository ..");
        this.shutdownServiceExportExecutor();
        this.shutdownServiceReferExecutor();
        this.data.values().forEach(executors -> {
            if (executors != null) {
                executors.values().forEach(executor -> {
                    if (executor != null && !executor.isShutdown()) {
                        try {
                            ExecutorUtil.shutdownNow(executor, 100);
                        }
                        catch (Throwable ignored) {
                            logger.warn("0-17", "", "", ignored.getMessage(), ignored);
                        }
                    }
                });
            }
        });
        this.data.clear();
    }

    private void shutdownExecutorService(ExecutorService executorService, String name) {
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            String msg = "shutdown executor service [" + name + "] failed: ";
            logger.warn("0-17", "", "", msg + e.getMessage(), e);
        }
    }

    @Override
    public void setExtensionAccessor(ExtensionAccessor extensionAccessor) {
        this.extensionAccessor = extensionAccessor;
    }

    @Override
    public ScheduledExecutorService nextScheduledExecutor() {
        return this.frameworkExecutorRepository.nextScheduledExecutor();
    }

    @Override
    public ExecutorService nextExecutorExecutor() {
        return this.frameworkExecutorRepository.nextExecutorExecutor();
    }

    @Override
    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor() {
        return this.frameworkExecutorRepository.getServiceDiscoveryAddressNotificationExecutor();
    }

    @Override
    public ScheduledExecutorService getMetadataRetryExecutor() {
        return this.frameworkExecutorRepository.getMetadataRetryExecutor();
    }

    @Override
    public ScheduledExecutorService getRegistryNotificationExecutor() {
        return this.frameworkExecutorRepository.getRegistryNotificationExecutor();
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.frameworkExecutorRepository.getSharedExecutor();
    }

    @Override
    public ScheduledExecutorService getSharedScheduledExecutor() {
        return this.frameworkExecutorRepository.getSharedScheduledExecutor();
    }

    @Override
    public ExecutorService getPoolRouterExecutor() {
        return this.frameworkExecutorRepository.getPoolRouterExecutor();
    }

    @Override
    public ScheduledExecutorService getConnectivityScheduledExecutor() {
        return this.frameworkExecutorRepository.getConnectivityScheduledExecutor();
    }

    @Override
    public ScheduledExecutorService getCacheRefreshingScheduledExecutor() {
        return this.frameworkExecutorRepository.getCacheRefreshingScheduledExecutor();
    }

    @Override
    public ExecutorService getMappingRefreshingExecutor() {
        return this.frameworkExecutorRepository.getMappingRefreshingExecutor();
    }

    @Override
    public ExecutorSupport getExecutorSupport(URL url) {
        if (this.executorSupport == null) {
            this.executorSupport = new DefaultExecutorSupport(url);
        }
        return this.executorSupport;
    }
}

