/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compiler.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.compiler.Compiler;
import org.apache.dubbo.common.compiler.support.ClassUtils;

public abstract class AbstractCompiler
implements Compiler {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([$_a-zA-Z][$_a-zA-Z0-9\\.]*);");
    private static final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([$_a-zA-Z][$_a-zA-Z0-9]*)\\s+");
    private static final Map<String, Lock> CLASS_IN_CREATION_MAP = new ConcurrentHashMap<String, Lock>();

    @Override
    public Class<?> compile(Class<?> neighbor, String code, ClassLoader classLoader) {
        Matcher matcher = PACKAGE_PATTERN.matcher(code = code.trim());
        String pkg = matcher.find() ? matcher.group(1) : "";
        matcher = CLASS_PATTERN.matcher(code);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No such class name in " + code);
        }
        String cls = matcher.group(1);
        String className = pkg != null && pkg.length() > 0 ? pkg + "." + cls : cls;
        Lock lock = CLASS_IN_CREATION_MAP.get(className);
        if (lock == null) {
            CLASS_IN_CREATION_MAP.putIfAbsent(className, new ReentrantLock());
            lock = CLASS_IN_CREATION_MAP.get(className);
        }
        try {
            lock.lock();
            Class<?> clazz = Class.forName(className, true, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (!code.endsWith("}")) {
                throw new IllegalStateException("The java code not endsWith \"}\", code: \n" + code + "\n");
            }
            try {
                Class<?> clazz = this.doCompile(neighbor, classLoader, className, code);
                return clazz;
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new IllegalStateException("Failed to compile class, cause: " + t.getMessage() + ", class: " + className + ", code: \n" + code + "\n, stack: " + ClassUtils.toString(t));
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected Class<?> doCompile(ClassLoader classLoader, String name, String source) throws Throwable {
        return null;
    }

    protected Class<?> doCompile(Class<?> neighbor, ClassLoader classLoader, String name, String source) throws Throwable {
        return this.doCompile(classLoader, name, source);
    }
}

