/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.metrics2.lib;

import java.util.concurrent.atomic.AtomicLong;
import oadd.org.apache.hadoop.classification.InterfaceAudience;
import oadd.org.apache.hadoop.classification.InterfaceStability;
import oadd.org.apache.hadoop.metrics2.MetricsInfo;
import oadd.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import oadd.org.apache.hadoop.metrics2.lib.MutableCounter;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableCounterLong
extends MutableCounter {
    private AtomicLong value = new AtomicLong();

    public MutableCounterLong(MetricsInfo info, long initValue) {
        super(info);
        this.value.set(initValue);
    }

    @Override
    public void incr() {
        this.incr(1L);
    }

    public void incr(long delta) {
        this.value.addAndGet(delta);
        this.setChanged();
    }

    public long value() {
        return this.value.get();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.info(), this.value());
            this.clearChanged();
        }
    }
}

