/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.hadoop.io.compress.bzip2;

import oadd.org.apache.hadoop.conf.Configuration;
import oadd.org.apache.hadoop.io.compress.Compressor;
import oadd.org.apache.hadoop.io.compress.Decompressor;
import oadd.org.apache.hadoop.io.compress.bzip2.BZip2DummyCompressor;
import oadd.org.apache.hadoop.io.compress.bzip2.BZip2DummyDecompressor;
import oadd.org.apache.hadoop.io.compress.bzip2.Bzip2Compressor;
import oadd.org.apache.hadoop.io.compress.bzip2.Bzip2Decompressor;
import oadd.org.apache.hadoop.util.NativeCodeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bzip2Factory {
    private static final Logger LOG = LoggerFactory.getLogger(Bzip2Factory.class);
    private static String bzip2LibraryName = "";
    private static boolean nativeBzip2Loaded;

    public static synchronized boolean isNativeBzip2Loaded(Configuration conf) {
        String libname = conf.get("oadd.io.compression.codec.bzip2.library", "system-native");
        if (!bzip2LibraryName.equals(libname)) {
            nativeBzip2Loaded = false;
            bzip2LibraryName = libname;
            if (libname.equals("java-builtin")) {
                LOG.info("Using pure-Java version of bzip2 library");
            } else if (NativeCodeLoader.isNativeCodeLoaded()) {
                try {
                    Bzip2Compressor.initSymbols(libname);
                    Bzip2Decompressor.initSymbols(libname);
                    nativeBzip2Loaded = true;
                    LOG.info("Successfully loaded & initialized native-bzip2 library " + libname);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to load/initialize native-bzip2 library " + libname + ", will use pure-Java version");
                }
            }
        }
        return nativeBzip2Loaded;
    }

    public static String getLibraryName(Configuration conf) {
        if (Bzip2Factory.isNativeBzip2Loaded(conf)) {
            return Bzip2Compressor.getLibraryName();
        }
        return bzip2LibraryName;
    }

    public static Class<? extends Compressor> getBzip2CompressorType(Configuration conf) {
        return Bzip2Factory.isNativeBzip2Loaded(conf) ? Bzip2Compressor.class : BZip2DummyCompressor.class;
    }

    public static Compressor getBzip2Compressor(Configuration conf) {
        return Bzip2Factory.isNativeBzip2Loaded(conf) ? new Bzip2Compressor(conf) : new BZip2DummyCompressor();
    }

    public static Class<? extends Decompressor> getBzip2DecompressorType(Configuration conf) {
        return Bzip2Factory.isNativeBzip2Loaded(conf) ? Bzip2Decompressor.class : BZip2DummyDecompressor.class;
    }

    public static Decompressor getBzip2Decompressor(Configuration conf) {
        return Bzip2Factory.isNativeBzip2Loaded(conf) ? new Bzip2Decompressor() : new BZip2DummyDecompressor();
    }

    public static void setBlockSize(Configuration conf, int blockSize) {
        conf.setInt("bzip2.compress.blocksize", blockSize);
    }

    public static int getBlockSize(Configuration conf) {
        return conf.getInt("bzip2.compress.blocksize", 9);
    }

    public static void setWorkFactor(Configuration conf, int workFactor) {
        conf.setInt("bzip2.compress.workfactor", workFactor);
    }

    public static int getWorkFactor(Configuration conf) {
        return conf.getInt("bzip2.compress.workfactor", 30);
    }
}

