/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.RepeatedListHolder;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedListVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.impl.NullReader;
import oadd.org.apache.drill.exec.vector.complex.impl.RepeatedListWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class RepeatedListReaderImpl
extends AbstractFieldReader {
    private static final int NO_VALUES = 0x7FFFFFFE;
    private static final TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.LIST);
    private final String name;
    private final RepeatedListVector container;
    private FieldReader reader;
    private int currentOffset;
    private int maxOffset;

    public RepeatedListReaderImpl(String name, RepeatedListVector container) {
        this.name = name;
        this.container = container;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        RepeatedListWriter impl = (RepeatedListWriter)writer;
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.container);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        RepeatedListWriter impl = (RepeatedListWriter)writer.list(name);
        impl.container.copyFromSafe(this.idx(), impl.idx(), this.container);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.maxOffset = 0;
        if (this.reader != null) {
            this.reader.reset();
        }
        this.reader = null;
    }

    @Override
    public int size() {
        UInt4Vector.Accessor offsetsAccessor = this.container.getOffsetVector().getAccessor();
        return this.isEmpty() ? 0 : offsetsAccessor.get(this.idx() + 1) - offsetsAccessor.get(this.idx());
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index == 0x7FFFFFFE) {
            this.currentOffset = 0x7FFFFFFE;
            return;
        }
        super.setPosition(index);
        RepeatedListHolder h2 = new RepeatedListHolder();
        this.container.getAccessor().get(index, h2);
        if (h2.start == h2.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            this.currentOffset = h2.start - 1;
            this.maxOffset = h2.end - 1;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.maxOffset) {
            ++this.currentOffset;
            if (this.reader != null) {
                this.reader.setPosition(this.currentOffset);
            }
            return true;
        }
        this.currentOffset = 0x7FFFFFFE;
        return false;
    }

    @Override
    public Object readObject() {
        return this.container.getAccessor().getObject(this.idx());
    }

    @Override
    public FieldReader reader() {
        if (this.reader == null) {
            ValueVector child = this.container.getChild(this.name);
            this.reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.reader.setPosition(this.currentOffset);
        }
        return this.reader;
    }

    public boolean isEmpty() {
        return this.currentOffset == 0x7FFFFFFE;
    }

    @Override
    public boolean isSet() {
        return true;
    }
}

