/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import oadd.org.apache.drill.common.KerberosUtil;
import oadd.org.apache.drill.common.config.DrillConfig;
import oadd.org.apache.drill.common.config.DrillProperties;
import oadd.org.apache.drill.exec.exception.DrillbitStartupException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.CoordinationProtos;
import oadd.org.apache.drill.exec.rpc.AbstractConnectionConfig;
import oadd.org.apache.drill.exec.rpc.security.AuthStringUtil;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import oadd.org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import oadd.org.apache.drill.exec.server.BootStrapContext;
import oadd.org.apache.hadoop.security.HadoopKerberosName;
import oadd.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitConnectionConfig
extends AbstractConnectionConfig {
    private static final Logger logger = LoggerFactory.getLogger(BitConnectionConfig.class);
    private final String authMechanismToUse;
    private final boolean useLoginPrincipal;

    protected BitConnectionConfig(BufferAllocator allocator, BootStrapContext context) throws DrillbitStartupException {
        super(allocator, context);
        DrillConfig config = context.getConfig();
        AuthenticatorProvider authProvider = this.getAuthProvider();
        if (config.getBoolean("drill.exec.security.bit.auth.enabled")) {
            this.authMechanismToUse = config.getString("drill.exec.security.bit.auth.mechanism");
            try {
                authProvider.getAuthenticatorFactory(this.authMechanismToUse);
            }
            catch (SaslException e) {
                throw new DrillbitStartupException(String.format("'%s' mechanism not found for bit-to-bit authentication. Please check authentication configuration.", this.authMechanismToUse));
            }
            this.encryptionContext.setEncryption(config.getBoolean("drill.exec.security.bit.encryption.sasl.enabled"));
            int maxWrappedSize = config.getInt("drill.exec.security.bit.encryption.sasl.max_wrapped_size");
            if (maxWrappedSize <= 0) {
                throw new DrillbitStartupException(String.format("Invalid value configured for bit.encryption.sasl.max_wrapped_size. Must be a positive integer in bytes with a recommended max value of %s", 0xFFFFFF));
            }
            if (maxWrappedSize > 0xFFFFFF) {
                logger.warn("The configured value of bit.encryption.sasl.max_wrapped_size: {} is too big. This may cause higher memory pressure. [Details: Recommended max value is {}]", (Object)maxWrappedSize, (Object)0xFFFFFF);
            }
            this.encryptionContext.setMaxWrappedSize(maxWrappedSize);
            logger.info("Configured bit-to-bit connections to require authentication using: {} with encryption: {}", (Object)this.authMechanismToUse, (Object)this.encryptionContext.getEncryptionCtxtString());
        } else {
            if (config.getBoolean("drill.exec.security.bit.encryption.sasl.enabled")) {
                throw new DrillbitStartupException("Invalid security configuration. Encryption using SASL is enabled with authentication disabled. Please check the security.bit configurations.");
            }
            this.authMechanismToUse = null;
        }
        this.useLoginPrincipal = config.getBoolean("drill.exec.security.bit.auth.use_login_principal");
    }

    public String getAuthMechanismToUse() {
        return this.authMechanismToUse;
    }

    public AuthenticatorFactory getAuthFactory(List<String> remoteMechanisms) throws SaslException {
        if (this.authMechanismToUse == null) {
            throw new SaslException("Authentication is not enabled");
        }
        if (!AuthStringUtil.listContains(remoteMechanisms, this.authMechanismToUse)) {
            throw new SaslException(String.format("Remote does not support authentication using '%s'", this.authMechanismToUse));
        }
        return this.getAuthProvider().getAuthenticatorFactory(this.authMechanismToUse);
    }

    public Map<String, ?> getSaslClientProperties(CoordinationProtos.DrillbitEndpoint remoteEndpoint, Map<String, String> overrides) throws IOException {
        DrillProperties properties = DrillProperties.createEmpty();
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        if (loginUser.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS) {
            HadoopKerberosName loginPrincipal = new HadoopKerberosName(loginUser.getUserName());
            if (!this.useLoginPrincipal) {
                properties.setProperty("principal", KerberosUtil.getPrincipalFromParts(loginPrincipal.getShortName(), remoteEndpoint.getAddress(), loginPrincipal.getRealm()));
            } else {
                properties.setProperty("principal", loginPrincipal.toString());
            }
        }
        properties.merge(overrides);
        return properties.stringPropertiesAsMap();
    }
}

