/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.util.Map;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEvent;
import oadd.org.apache.drill.exec.coord.store.TransientStoreEventType;
import oadd.org.apache.drill.exec.coord.zk.ZkEphemeralStore;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;

public class EventDispatcher<V>
implements PathChildrenCacheListener {
    public static final Map<PathChildrenCacheEvent.Type, TransientStoreEventType> MAPPINGS = ImmutableMap.builder().put(PathChildrenCacheEvent.Type.CHILD_ADDED, TransientStoreEventType.CREATE).put(PathChildrenCacheEvent.Type.CHILD_REMOVED, TransientStoreEventType.DELETE).put(PathChildrenCacheEvent.Type.CHILD_UPDATED, TransientStoreEventType.UPDATE).build();
    private final ZkEphemeralStore<V> store;

    protected EventDispatcher(ZkEphemeralStore<V> store) {
        this.store = Preconditions.checkNotNull(store, "store is required");
    }

    @Override
    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        PathChildrenCacheEvent.Type original = event.getType();
        TransientStoreEventType mapped = MAPPINGS.get((Object)original);
        if (mapped != null) {
            String path = event.getData().getPath();
            byte[] bytes = event.getData().getData();
            Object value = this.store.getConfig().getSerializer().deserialize(bytes);
            this.store.fireListeners(TransientStoreEvent.of(mapped, path, value));
        }
    }
}

