/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.ExpressionStringBuilder;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.PathSegment;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.parser.LogicalExpressionParser;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class SchemaPath
extends LogicalExpressionBase {
    public static final String DYNAMIC_STAR = "**";
    public static final SchemaPath STAR_COLUMN = SchemaPath.getSimplePath("**");
    private final PathSegment.NameSegment rootSegment;

    public SchemaPath(SchemaPath path) {
        this(path.rootSegment, path.getPosition());
    }

    public SchemaPath(PathSegment.NameSegment rootSegment) {
        this(rootSegment, ExpressionPosition.UNKNOWN);
    }

    @Deprecated
    public SchemaPath(String simpleName, ExpressionPosition pos) {
        this(new PathSegment.NameSegment(simpleName), pos);
    }

    public SchemaPath(PathSegment.NameSegment rootSegment, ExpressionPosition pos) {
        super(pos);
        this.rootSegment = rootSegment;
    }

    public static SchemaPath getSimplePath(String name) {
        return SchemaPath.getCompoundPath(name);
    }

    public static SchemaPath getCompoundPath(String ... path) {
        return SchemaPath.getCompoundPath(path.length, path);
    }

    public static SchemaPath getCompoundPath(int n, String ... path) {
        Preconditions.checkArgument(n > 0);
        PathSegment.NameSegment s2 = null;
        for (int i = n - 1; i >= 0; --i) {
            s2 = new PathSegment.NameSegment(path[i], s2);
        }
        return new SchemaPath(s2);
    }

    public PathSegment getLastSegment() {
        PathSegment s2 = this.rootSegment;
        while (s2.getChild() != null) {
            s2 = s2.getChild();
        }
        return s2;
    }

    public UserBitShared.NamePart getAsNamePart() {
        return SchemaPath.getNamePart(this.rootSegment);
    }

    private static UserBitShared.NamePart getNamePart(PathSegment s2) {
        UserBitShared.NamePart namePart;
        if (s2 == null) {
            return null;
        }
        UserBitShared.NamePart.Builder b = UserBitShared.NamePart.newBuilder();
        if (s2.getChild() != null && (namePart = SchemaPath.getNamePart(s2.getChild())) != null) {
            b.setChild(namePart);
        }
        if (s2.isArray()) {
            if (s2.getArraySegment().hasIndex()) {
                throw new IllegalStateException("You cannot convert a indexed schema path to a NamePart.  NameParts can only reference Vectors, not individual records or values.");
            }
            b.setType(UserBitShared.NamePart.Type.ARRAY);
        } else {
            b.setType(UserBitShared.NamePart.Type.NAME);
            b.setName(s2.getNameSegment().getPath());
        }
        return b.build();
    }

    private static PathSegment getPathSegment(UserBitShared.NamePart n) {
        PathSegment child;
        PathSegment pathSegment = child = n.hasChild() ? SchemaPath.getPathSegment(n.getChild()) : null;
        if (n.getType() == UserBitShared.NamePart.Type.ARRAY) {
            return new PathSegment.ArraySegment(child);
        }
        return new PathSegment.NameSegment(n.getName(), child);
    }

    public static SchemaPath create(UserBitShared.NamePart namePart) {
        Preconditions.checkArgument(namePart.getType() == UserBitShared.NamePart.Type.NAME);
        return new SchemaPath((PathSegment.NameSegment)SchemaPath.getPathSegment(namePart));
    }

    public SchemaPath getUnIndexed() {
        return new SchemaPath(this.getUnIndexedNameSegment(this.rootSegment, null));
    }

    private PathSegment.NameSegment getUnIndexedNameSegment(PathSegment currentSegment, PathSegment.NameSegment resultingSegment) {
        if (!currentSegment.isLastPath()) {
            resultingSegment = this.getUnIndexedNameSegment(currentSegment.getChild(), resultingSegment);
        }
        if (currentSegment.isNamed()) {
            String path = currentSegment.getNameSegment().getPath();
            return new PathSegment.NameSegment(path, resultingSegment);
        }
        return resultingSegment;
    }

    public static SchemaPath parseFromString(String expr) {
        if (expr == null || expr.isEmpty()) {
            return null;
        }
        if (DYNAMIC_STAR.equals(expr)) {
            return SchemaPath.getSimplePath(expr);
        }
        LogicalExpression logicalExpression = LogicalExpressionParser.parse(expr);
        if (logicalExpression instanceof SchemaPath) {
            return (SchemaPath)logicalExpression;
        }
        throw new IllegalStateException(String.format("Schema path is not a valid format: %s.", logicalExpression));
    }

    public boolean isSimplePath() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isArray() || seg.isLastPath()) continue;
            return false;
        }
        return true;
    }

    public boolean isArray() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isArray()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.rootSegment.isLastPath();
    }

    public boolean isDynamicStar() {
        return this.isLeaf() && this.nameEquals(DYNAMIC_STAR);
    }

    public boolean nameEquals(String name) {
        return this.rootSegment.nameEquals(name);
    }

    public String rootName() {
        return this.rootSegment.getPath();
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitSchemaPath(this, value);
    }

    public SchemaPath getChild(String childPath) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.NameSegment(childPath));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getChild(String childPath, Object originalValue, TypeProtos.MajorType valueType) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.NameSegment(childPath, originalValue, valueType));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getChild(int index) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(index));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getChild(int index, Object originalValue, TypeProtos.MajorType valueType) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(index, originalValue, valueType));
        return new SchemaPath(newRoot);
    }

    public PathSegment.NameSegment getRootSegment() {
        return this.rootSegment;
    }

    public String getAsUnescapedPath() {
        StringBuilder sb = new StringBuilder();
        PathSegment seg = this.getRootSegment();
        if (seg.isArray()) {
            throw new IllegalStateException("Drill doesn't currently support top level arrays");
        }
        sb.append(seg.getNameSegment().getPath());
        while ((seg = seg.getChild()) != null) {
            if (seg.isNamed()) {
                sb.append('.');
                sb.append(seg.getNameSegment().getPath());
                continue;
            }
            sb.append('[');
            sb.append(seg.getArraySegment().getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return Types.LATE_BIND_TYPE;
    }

    public int hashCode() {
        return this.rootSegment == null ? 0 : this.rootSegment.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SchemaPath && Objects.equals(this.rootSegment, ((SchemaPath)obj).rootSegment);
    }

    public boolean contains(SchemaPath path) {
        return this == path || path != null && (this.rootSegment == null || this.rootSegment.contains(path.rootSegment));
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Collections.emptyIterator();
    }

    public String toString() {
        return ExpressionStringBuilder.toString(this);
    }

    public String toExpr() {
        return ExpressionStringBuilder.toString(this);
    }

    public String getRootSegmentPath() {
        return this.rootSegment.getPath();
    }

    public static class De
    extends StdDeserializer<SchemaPath> {
        public De() {
            super(LogicalExpression.class);
        }

        @Override
        public SchemaPath deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return SchemaPath.parseFromString(jp.getText());
        }
    }
}

