/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ComparisonChain;

public final class Version
implements Comparable<Version> {
    private final String version;
    private final int major;
    private final int minor;
    private final int patch;
    private final int buildNumber;
    private final String qualifier;
    private final String lcQualifier;
    private static final Comparator<String> QUALIFIER_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String q1, String q2) {
            if (q1.equals(q2)) {
                return 0;
            }
            if ("snapshot".equals(q1)) {
                return -1;
            }
            if ("snapshot".equals(q2)) {
                return 1;
            }
            return q1.compareTo(q2);
        }
    };

    public Version(String version, int major, int minor, int patch, int buildNumber, String qualifier) {
        this.version = version;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.buildNumber = buildNumber;
        this.qualifier = qualifier;
        this.lcQualifier = qualifier.toLowerCase(Locale.ENGLISH);
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPatchVersion() {
        return this.patch;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.buildNumber, this.lcQualifier);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version dvi = (Version)obj;
        return this.major == dvi.major && this.minor == dvi.minor && this.patch == dvi.patch && this.buildNumber == dvi.buildNumber && Objects.equals(this.lcQualifier, dvi.lcQualifier);
    }

    public String toString() {
        return String.format("Version; %s", this.version);
    }

    @Override
    public int compareTo(Version o) {
        Preconditions.checkNotNull(o);
        return ComparisonChain.start().compare(this.major, o.major).compare(this.minor, o.minor).compare(this.patch, o.patch).compare(this.buildNumber, o.buildNumber).compare(this.lcQualifier, o.lcQualifier, QUALIFIER_COMPARATOR).result();
    }
}

