/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import oadd.org.apache.commons.lang3.StringEscapeUtils;

public class PlanStringBuilder {
    private final StringBuilder buf = new StringBuilder();
    private int fieldCount = 0;

    public PlanStringBuilder(Object node) {
        this(node.getClass().getSimpleName());
    }

    public PlanStringBuilder(String node) {
        this.buf.append(node).append(" [");
    }

    public PlanStringBuilder field(String key, String value) {
        if (value != null) {
            this.startField(key);
            this.buf.append("\"").append(value).append("\"");
        }
        return this;
    }

    public PlanStringBuilder unquotedField(String key, String value) {
        if (value != null) {
            this.startField(key);
            this.buf.append(value);
        }
        return this;
    }

    public PlanStringBuilder field(String key, Object value) {
        if (value != null) {
            this.startField(key);
            this.buf.append(value.toString());
        }
        return this;
    }

    public PlanStringBuilder field(String key, int value) {
        this.startField(key);
        this.buf.append(value);
        return this;
    }

    public PlanStringBuilder escapedField(String key, char value) {
        return this.escapedField(key, Character.toString(value));
    }

    public PlanStringBuilder escapedField(String key, String value) {
        return this.field(key, StringEscapeUtils.escapeJava(value));
    }

    public PlanStringBuilder maskedField(String key, String value) {
        return this.field(key, value == null ? null : "*******");
    }

    private void startField(String key) {
        if (this.fieldCount++ != 0) {
            this.buf.append(", ");
        }
        this.buf.append(key).append("=");
    }

    public String toString() {
        return this.buf.append("]").toString();
    }
}

