/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.module.afterburner.deser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oadd.com.fasterxml.jackson.core.Base64Variants;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.core.io.NumberInput;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.DeserializationFeature;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonMappingException;
import oadd.com.fasterxml.jackson.databind.MapperFeature;
import oadd.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import oadd.com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import oadd.com.fasterxml.jackson.databind.util.ClassUtil;
import oadd.com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import oadd.com.fasterxml.jackson.module.afterburner.deser.DelegatingPropertyMutator;
import oadd.com.fasterxml.jackson.module.afterburner.deser.SuperSonicBeanDeserializer;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty.Delegating {
    private static final long serialVersionUID = 1L;
    protected BeanPropertyMutator _propertyMutator;
    protected final int _optimizedIndex;
    protected final boolean _skipNulls;
    private volatile boolean broken = false;

    protected OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._propertyMutator = mutator;
        this._optimizedIndex = index;
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    @Override
    public final SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
        SettableBeanProperty newDelegate = this.delegate.withValueDeserializer(deser);
        if (newDelegate == this.delegate) {
            return this;
        }
        if (!this._isDefaultDeserializer(deser)) {
            return newDelegate;
        }
        return this.withDelegate(newDelegate);
    }

    @Override
    protected abstract SettableBeanProperty withDelegate(SettableBeanProperty var1);

    public abstract SettableBeanProperty withMutator(BeanPropertyMutator var1);

    @Override
    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    @Override
    public abstract void set(Object var1, Object var2) throws IOException;

    @Override
    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this.delegate.setAndReturn(instance, value);
    }

    public int getOptimizedIndex() {
        return this._optimizedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _reportProblem(Object bean, Object value, Throwable e) throws IOException {
        if (e instanceof IllegalAccessError || e instanceof SecurityException) {
            OptimizedSettableBeanProperty optimizedSettableBeanProperty = this;
            synchronized (optimizedSettableBeanProperty) {
                if (!this.broken) {
                    this.broken = true;
                    String msg = String.format("Disabling Afterburner deserialization for %s (field #%d; mutator %s), due to access error (type %s, message=%s)%n", bean.getClass(), this._optimizedIndex, this.getClass().getName(), e.getClass().getName(), e.getMessage());
                    Logger.getLogger(BeanPropertyMutator.class.getName()).log(Level.WARNING, msg, e);
                    this._propertyMutator = new DelegatingPropertyMutator(this.delegate);
                }
            }
            this.delegate.set(bean, value);
            return;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected final boolean _deserializeBoolean(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                this._failNullToPrimitiveCoercion(ctxt, "boolean");
            }
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            this._verifyScalarCoercion(ctxt, p, "boolean");
            if (p.getNumberType() == JsonParser.NumberType.INT) {
                return p.getIntValue() != 0;
            }
            return this._deserializeBooleanFromOther(p, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            this._verifyScalarCoercion(ctxt, p, "boolean");
            String text = p.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text) || text.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text)) {
                return false;
            }
            throw ctxt.weirdStringException(text, Boolean.TYPE, "only \"true\" or \"false\" recognized");
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            boolean parsed = this._deserializeBooleanFromOther(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this._handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(Boolean.TYPE, p);
    }

    protected final short _deserializeShort(JsonParser jp, DeserializationContext ctxt) throws IOException {
        int value = this._deserializeInt(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(String.valueOf(value), Short.TYPE, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _deserializeInt(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return p.getIntValue();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            this._verifyScalarCoercion(ctxt, p, "int");
            String text = p.getText().trim();
            if (this._hasTextualNull(text)) {
                return 0;
            }
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw ctxt.weirdStringException(text, Integer.TYPE, "Overflow: numeric value (" + text + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, Integer.TYPE, "not a valid int value");
            }
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "int");
            }
            return p.getValueAsInt();
        }
        if (t == JsonToken.VALUE_NULL) {
            if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                this._failNullToPrimitiveCoercion(ctxt, "int");
            }
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            int parsed = this._deserializeInt(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this._handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Integer)ctxt.handleUnexpectedToken(Integer.TYPE, p);
    }

    protected final long _deserializeLong(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "long");
                }
                return p.getValueAsLong();
            }
            case 6: {
                this._verifyScalarCoercion(ctxt, p, "long");
                String text = p.getText().trim();
                if (text.length() == 0 || this._hasTextualNull(text)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong(text);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ctxt.weirdStringException(text, Long.TYPE, "not a valid long value");
                }
            }
            case 11: {
                if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                    this._failNullToPrimitiveCoercion(ctxt, "long");
                }
                return 0L;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                long parsed = this._deserializeLong(p, ctxt);
                JsonToken t = p.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this._handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
        }
        return (Long)ctxt.handleUnexpectedToken(Long.TYPE, p);
    }

    protected final String _deserializeString(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 6: {
                return p.getText();
            }
            case 11: {
                return null;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                String parsed = this._deserializeString(p, ctxt);
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    this._handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
            case 12: {
                Object ob = p.getEmbeddedObject();
                if (ob == null) {
                    return null;
                }
                if (ob instanceof byte[]) {
                    return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
                }
                return ob.toString();
            }
            default: {
                String text = p.getValueAsString();
                if (text == null) break;
                return text;
            }
        }
        return (String)ctxt.handleUnexpectedToken(String.class, p);
    }

    protected final boolean _deserializeBooleanFromOther(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getNumberType() == JsonParser.NumberType.LONG) {
            return p.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = p.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void _failNullToPrimitiveCoercion(DeserializationContext ctxt, String type) throws JsonMappingException {
        ctxt.reportInputMismatch(this.getType(), "Cannot map `null` into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", type);
    }

    protected void _failDoubleToIntCoercion(JsonParser p, DeserializationContext ctxt, String type) throws IOException {
        ctxt.reportInputMismatch(this.getType(), "Can not coerce a floating-point value (%s) into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", p.getValueAsString(), type);
    }

    private void _verifyScalarCoercion(DeserializationContext ctxt, JsonParser parser, String type) throws IOException {
        MapperFeature feat = MapperFeature.ALLOW_COERCION_OF_SCALARS;
        if (!ctxt.isEnabled(feat)) {
            ctxt.reportInputMismatch(this.getType(), "Cannot coerce JSON %s value (%s) into %s (enable `%s.%s` to allow)", parser.currentToken().name(), parser.readValueAsTree(), type, feat.getClass().getSimpleName(), feat.name());
        }
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected boolean _isDefaultDeserializer(JsonDeserializer<?> deser) {
        return deser == null || deser instanceof SuperSonicBeanDeserializer || ClassUtil.isJacksonStdImpl(deser);
    }

    protected void _handleMissingEndArrayForSingle(JsonParser p, DeserializationContext ctxt) throws IOException {
        JavaType type = this.getType();
        ctxt.reportWrongTokenException(type, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single %s value but there was more than a single value in the array", this.getType());
    }
}

