/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.codahale.metrics.health;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.codahale.metrics.health.HealthCheckRegistry;

public class SharedHealthCheckRegistries {
    private static final ConcurrentMap<String, HealthCheckRegistry> REGISTRIES = new ConcurrentHashMap<String, HealthCheckRegistry>();
    private static AtomicReference<String> defaultRegistryName = new AtomicReference();

    static void setDefaultRegistryName(AtomicReference<String> defaultRegistryName) {
        SharedHealthCheckRegistries.defaultRegistryName = defaultRegistryName;
    }

    private SharedHealthCheckRegistries() {
    }

    public static void clear() {
        REGISTRIES.clear();
    }

    public static Set<String> names() {
        return REGISTRIES.keySet();
    }

    public static void remove(String key) {
        REGISTRIES.remove(key);
    }

    public static HealthCheckRegistry add(String name, HealthCheckRegistry registry) {
        return REGISTRIES.putIfAbsent(name, registry);
    }

    public static HealthCheckRegistry getOrCreate(String name) {
        HealthCheckRegistry existing = (HealthCheckRegistry)REGISTRIES.get(name);
        if (existing == null) {
            HealthCheckRegistry created = new HealthCheckRegistry();
            HealthCheckRegistry raced = SharedHealthCheckRegistries.add(name, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public static synchronized HealthCheckRegistry setDefault(String name) {
        HealthCheckRegistry registry = SharedHealthCheckRegistries.getOrCreate(name);
        return SharedHealthCheckRegistries.setDefault(name, registry);
    }

    public static HealthCheckRegistry setDefault(String name, HealthCheckRegistry healthCheckRegistry) {
        if (defaultRegistryName.compareAndSet(null, name)) {
            SharedHealthCheckRegistries.add(name, healthCheckRegistry);
            return healthCheckRegistry;
        }
        throw new IllegalStateException("Default health check registry is already set.");
    }

    public static HealthCheckRegistry getDefault() {
        HealthCheckRegistry healthCheckRegistry = SharedHealthCheckRegistries.tryGetDefault();
        if (healthCheckRegistry != null) {
            return healthCheckRegistry;
        }
        throw new IllegalStateException("Default registry name has not been set.");
    }

    public static HealthCheckRegistry tryGetDefault() {
        String name = defaultRegistryName.get();
        if (name != null) {
            return SharedHealthCheckRegistries.getOrCreate(name);
        }
        return null;
    }
}

