/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ListObjectsV2Request;
import com.aliyun.oss.model.ListObjectsV2Result;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.factory.OssClientFactory;
import org.apache.dolphinscheduler.common.model.OssConnection;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssStorageOperator
implements Closeable,
StorageOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OssStorageOperator.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String bucketName;
    private String endPoint;
    private OssConnection ossConnection;
    private OSS ossClient;

    public void init() {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = this.buildOssConnection();
        this.ossClient = this.buildOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    public void init(OssConnection ossConnection) {
        this.accessKeyId = this.readOssAccessKeyID();
        this.accessKeySecret = this.readOssAccessKeySecret();
        this.endPoint = this.readOssEndPoint();
        this.region = this.readOssRegion();
        this.bucketName = this.readOssBucketName();
        this.ossConnection = ossConnection;
        this.ossClient = this.getOssClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    protected String readOssAccessKeyID() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.id");
    }

    protected String readOssAccessKeySecret() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.access.key.secret");
    }

    protected String readOssRegion() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.region");
    }

    protected String readOssBucketName() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.bucket.name");
    }

    protected String readOssEndPoint() {
        return PropertyUtils.getString((String)"resource.alibaba.cloud.oss.endpoint");
    }

    protected OssConnection buildOssConnection() {
        return new OssConnection(this.accessKeyId, this.accessKeySecret, this.endPoint);
    }

    @Override
    public void close() throws IOException {
        this.ossClient.shutdown();
    }

    public void createTenantDirIfNotExists(String tenantCode) throws Exception {
        this.mkdir(tenantCode, this.getOssResDir(tenantCode));
        this.mkdir(tenantCode, this.getOssUdfDir(tenantCode));
    }

    public String getResDir(String tenantCode) {
        return this.getOssResDir(tenantCode) + "/";
    }

    public String getUdfDir(String tenantCode) {
        return this.getOssUdfDir(tenantCode) + "/";
    }

    public boolean mkdir(String tenantCode, String path) throws IOException {
        String key = path + "/";
        if (!this.ossClient.doesObjectExist(this.bucketName, key)) {
            this.createOssPrefix(this.bucketName, key);
        }
        return true;
    }

    protected void createOssPrefix(String bucketName, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, (InputStream)emptyContent, metadata);
        this.ossClient.putObject(putObjectRequest);
    }

    public String getResourceFullName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", this.getOssResDir(tenantCode), fileName);
    }

    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    public boolean delete(String fullName, List<String> childrenPathList, boolean recursive) throws IOException {
        childrenPathList.add(fullName);
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucketName).withKeys(childrenPathList);
        try {
            this.ossClient.deleteObjects(deleteObjectsRequest);
        }
        catch (Exception e) {
            log.error("delete objects error", (Throwable)e);
            return false;
        }
        return true;
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) throws IOException {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWith755((Path)dstFile.getParentFile().toPath());
        }
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, srcFilePath);
        try (InputStream ossInputStream = ossObject.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = ossInputStream.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
        catch (OSSException e) {
            throw new IOException(e);
        }
        catch (FileNotFoundException e) {
            log.error("cannot find the destination file {}", (Object)dstFilePath);
            throw e;
        }
    }

    public boolean exists(String fileName) throws IOException {
        return this.ossClient.doesObjectExist(this.bucketName, fileName);
    }

    public boolean delete(String filePath, boolean recursive) throws IOException {
        try {
            this.ossClient.deleteObject(this.bucketName, filePath);
            return true;
        }
        catch (OSSException e) {
            log.error("fail to delete the object, the resource path is {}", (Object)filePath, (Object)e);
            return false;
        }
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        this.ossClient.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        if (deleteSource) {
            this.ossClient.deleteObject(this.bucketName, srcPath);
        }
        return true;
    }

    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
            case ALL: {
                return this.getOssDataBasePath();
            }
        }
        return "";
    }

    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            this.ossClient.putObject(this.bucketName, dstPath, new File(srcFile));
            if (deleteSource) {
                Files.delete(Paths.get(srcFile, new String[0]));
            }
            return true;
        }
        catch (OSSException e) {
            log.error("upload failed, the bucketName is {}, the filePath is {}", new Object[]{this.bucketName, dstPath, e});
            return false;
        }
    }

    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("file path:{} is empty", (Object)filePath);
            return Collections.emptyList();
        }
        OSSObject ossObject = this.ossClient.getObject(this.bucketName, filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public ResUploadType returnStorageType() {
        return ResUploadType.OSS;
    }

    public List<StorageEntity> listFilesStatusRecursively(String path, String defaultPath, String tenantCode, ResourceType type) {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<StorageEntity> foldersToFetch = new LinkedList<StorageEntity>();
        StorageEntity initialEntity = null;
        try {
            initialEntity = this.getFileStatus(path, defaultPath, tenantCode, type);
        }
        catch (Exception e) {
            log.error("error while listing files status recursively, path: {}", (Object)path, (Object)e);
            return storageEntityList;
        }
        foldersToFetch.add(initialEntity);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = ((StorageEntity)foldersToFetch.pop()).getFullName();
            try {
                List<StorageEntity> tempList = this.listFilesStatus(pathToExplore, defaultPath, tenantCode, type);
                for (StorageEntity temp : tempList) {
                    if (!temp.isDirectory()) continue;
                    foldersToFetch.add(temp);
                }
                storageEntityList.addAll(tempList);
            }
            catch (Exception e) {
                log.error("error while listing files stat:wus recursively, path: {}", (Object)pathToExplore, (Object)e);
            }
        }
        return storageEntityList;
    }

    public List<StorageEntity> listFilesStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        ListObjectsV2Result result = null;
        String nextContinuationToken = null;
        do {
            try {
                ListObjectsV2Request request = new ListObjectsV2Request();
                request.setBucketName(this.bucketName);
                request.setPrefix(path);
                request.setDelimiter("/");
                request.setContinuationToken(nextContinuationToken);
                result = this.ossClient.listObjectsV2(request);
            }
            catch (Exception e) {
                throw new ServiceException("Get OSS file list exception", (Throwable)e);
            }
            List summaries = result.getObjectSummaries();
            for (OSSObjectSummary summary : summaries) {
                if (summary.getKey().endsWith("/")) continue;
                String[] aliasArr = summary.getKey().split("/");
                String alias = aliasArr[aliasArr.length - 1];
                String fileName = StringUtils.difference((String)defaultPath, (String)summary.getKey());
                StorageEntity entity = new StorageEntity();
                entity.setAlias(alias);
                entity.setFileName(fileName);
                entity.setFullName(summary.getKey());
                entity.setDirectory(false);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(summary.getSize());
                entity.setCreateTime(summary.getLastModified());
                entity.setUpdateTime(summary.getLastModified());
                entity.setPfullName(path);
                storageEntityList.add(entity);
            }
            for (String commonPrefix : result.getCommonPrefixes()) {
                String suffix = StringUtils.difference((String)path, (String)commonPrefix);
                String fileName = StringUtils.difference((String)defaultPath, (String)commonPrefix);
                StorageEntity entity = new StorageEntity();
                entity.setAlias(suffix);
                entity.setFileName(fileName);
                entity.setFullName(commonPrefix);
                entity.setDirectory(true);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(0L);
                entity.setCreateTime(null);
                entity.setUpdateTime(null);
                entity.setPfullName(path);
                storageEntityList.add(entity);
            }
            nextContinuationToken = result.getNextContinuationToken();
        } while (result.isTruncated());
        return storageEntityList;
    }

    public StorageEntity getFileStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        ListObjectsV2Result result;
        ListObjectsV2Request request = new ListObjectsV2Request();
        request.setBucketName(this.bucketName);
        request.setPrefix(path);
        request.setDelimiter("/");
        try {
            result = this.ossClient.listObjectsV2(request);
        }
        catch (Exception e) {
            throw new ServiceException("Get OSS file list exception", (Throwable)e);
        }
        List summaries = result.getObjectSummaries();
        if (path.endsWith("/")) {
            String alias = this.findDirAlias(path);
            String fileName = StringUtils.difference((String)defaultPath, (String)path);
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(path);
            entity.setDirectory(true);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(0L);
            return entity;
        }
        if (summaries.size() > 0) {
            OSSObjectSummary summary = (OSSObjectSummary)summaries.get(0);
            String[] aliasArr = summary.getKey().split("/");
            String alias = aliasArr[aliasArr.length - 1];
            String fileName = StringUtils.difference((String)defaultPath, (String)summary.getKey());
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(summary.getKey());
            entity.setDirectory(false);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(summary.getSize());
            entity.setCreateTime(summary.getLastModified());
            entity.setUpdateTime(summary.getLastModified());
            return entity;
        }
        throw new FileNotFoundException("Object is not found in OSS Bucket: " + this.bucketName);
    }

    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    public String getOssResDir(String tenantCode) {
        return String.format("%s/resources", this.getOssTenantDir(tenantCode));
    }

    public String getOssUdfDir(String tenantCode) {
        return String.format("%s/udfs", this.getOssTenantDir(tenantCode));
    }

    public String getOssTenantDir(String tenantCode) {
        return String.format("%s/%s", this.getOssDataBasePath(), tenantCode);
    }

    public String getOssDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH.replaceFirst("/", "");
    }

    protected void deleteTenantCode(String tenantCode) {
        this.deleteDir(this.getResDir(tenantCode));
        this.deleteDir(this.getUdfDir(tenantCode));
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.alibaba.cloud.oss.bucket.name is empty");
        }
        boolean existsBucket = this.ossClient.doesBucketExist(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found, the current regionName is {}", (Object)bucketName, (Object)this.region);
    }

    protected void deleteDir(String directoryName) {
        if (this.ossClient.doesObjectExist(this.bucketName, directoryName)) {
            this.ossClient.deleteObject(this.bucketName, directoryName);
        }
    }

    protected OSS buildOssClient() {
        return OssClientFactory.buildOssClient((OssConnection)this.ossConnection);
    }

    private String findDirAlias(String dirPath) {
        if (!dirPath.endsWith("/")) {
            return dirPath;
        }
        Path path = Paths.get(dirPath, new String[0]);
        return path.getName(path.getNameCount() - 1) + "/";
    }

    @Generated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public OssConnection getOssConnection() {
        return this.ossConnection;
    }

    @Generated
    public OSS getOssClient() {
        return this.ossClient;
    }

    @Generated
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Generated
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setOssConnection(OssConnection ossConnection) {
        this.ossConnection = ossConnection;
    }

    @Generated
    public void setOssClient(OSS ossClient) {
        this.ossClient = ossClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssStorageOperator)) {
            return false;
        }
        OssStorageOperator other = (OssStorageOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        OssConnection this$ossConnection = this.getOssConnection();
        OssConnection other$ossConnection = other.getOssConnection();
        if (this$ossConnection == null ? other$ossConnection != null : !this$ossConnection.equals(other$ossConnection)) {
            return false;
        }
        OSS this$ossClient = this.getOssClient();
        OSS other$ossClient = other.getOssClient();
        return !(this$ossClient == null ? other$ossClient != null : !this$ossClient.equals(other$ossClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OssStorageOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        OssConnection $ossConnection = this.getOssConnection();
        result = result * 59 + ($ossConnection == null ? 43 : $ossConnection.hashCode());
        OSS $ossClient = this.getOssClient();
        result = result * 59 + ($ossClient == null ? 43 : $ossClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OssStorageOperator(accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", region=" + this.getRegion() + ", bucketName=" + this.getBucketName() + ", endPoint=" + this.getEndPoint() + ", ossConnection=" + this.getOssConnection() + ", ossClient=" + this.getOssClient() + ")";
    }
}

