/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.sql.Connection;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);

    public static void checkDatasourceParam(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        DataSourceUtils.getDatasourceProcessor(baseDataSourceParamDTO.getType()).checkDatasourceParam(baseDataSourceParamDTO);
    }

    public static ConnectionParam buildConnectionParams(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        ConnectionParam connectionParams = DataSourceUtils.getDatasourceProcessor(baseDataSourceParamDTO.getType()).createConnectionParams(baseDataSourceParamDTO);
        logger.info("parameters map:{}", (Object)connectionParams);
        return connectionParams;
    }

    public static ConnectionParam buildConnectionParams(DbType dbType, String connectionJson) {
        return DataSourceUtils.getDatasourceProcessor(dbType).createConnectionParams(connectionJson);
    }

    public static String getJdbcUrl(DbType dbType, ConnectionParam baseConnectionParam) {
        return DataSourceUtils.getDatasourceProcessor(dbType).getJdbcUrl(baseConnectionParam);
    }

    public static Connection getConnection(DbType dbType, ConnectionParam connectionParam) {
        try {
            return DataSourceUtils.getDatasourceProcessor(dbType).getConnection(connectionParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDatasourceDriver(DbType dbType) {
        return DataSourceUtils.getDatasourceProcessor(dbType).getDatasourceDriver();
    }

    public static BaseDataSourceParamDTO buildDatasourceParamDTO(DbType dbType, String connectionParams) {
        return DataSourceUtils.getDatasourceProcessor(dbType).createDatasourceParamDTO(connectionParams);
    }

    public static DataSourceProcessor getDatasourceProcessor(DbType dbType) {
        Map<String, DataSourceProcessor> dataSourceProcessorMap = DataSourceProcessorProvider.getInstance().getDataSourceProcessorMap();
        if (!dataSourceProcessorMap.containsKey(dbType.name())) {
            throw new IllegalArgumentException("illegal datasource type");
        }
        return dataSourceProcessorMap.get(dbType.name());
    }

    public static String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        return DataSourceUtils.getDatasourceProcessor(dbType).getDatasourceUniqueId(connectionParam, dbType);
    }

    public static BaseDataSourceParamDTO buildDatasourceParam(String param) {
        ObjectNode jsonNodes = JSONUtils.parseObject((String)param);
        return DataSourceUtils.getDatasourceProcessor(DbType.ofName((String)jsonNodes.get("type").asText().toUpperCase())).castDatasourceParamDTO(param);
    }
}

