/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.plugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourcePluginManager;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannel;
import org.apache.dolphinscheduler.spi.datasource.DataSourceClient;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceClientProvider {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceClientProvider.class);
    private static final long duration = PropertyUtils.getLong((String)"kerberos.expire.time", (long)24L);
    private static final Cache<String, DataSourceClient> uniqueId2dataSourceClientCache = CacheBuilder.newBuilder().expireAfterWrite(duration, TimeUnit.HOURS).removalListener(notification -> {
        try (DataSourceClient closedClient = (DataSourceClient)notification.getValue();){
            logger.info("Datasource: {} is removed from cache due to expire", notification.getKey());
        }
    }).maximumSize(100L).build();
    private DataSourcePluginManager dataSourcePluginManager;

    private DataSourceClientProvider() {
        this.initDataSourcePlugin();
    }

    public static DataSourceClientProvider getInstance() {
        return DataSourceClientProviderHolder.INSTANCE;
    }

    public Connection getConnection(DbType dbType, ConnectionParam connectionParam) throws ExecutionException {
        BaseConnectionParam baseConnectionParam = (BaseConnectionParam)connectionParam;
        String datasourceUniqueId = DataSourceUtils.getDatasourceUniqueId((ConnectionParam)baseConnectionParam, dbType);
        logger.info("Get connection from datasource {}", (Object)datasourceUniqueId);
        DataSourceClient dataSourceClient = (DataSourceClient)uniqueId2dataSourceClientCache.get((Object)datasourceUniqueId, () -> {
            Map<String, DataSourceChannel> dataSourceChannelMap = this.dataSourcePluginManager.getDataSourceChannelMap();
            DataSourceChannel dataSourceChannel = dataSourceChannelMap.get(dbType.getDescp());
            if (null == dataSourceChannel) {
                throw new RuntimeException(String.format("datasource plugin '%s' is not found", dbType.getDescp()));
            }
            return dataSourceChannel.createDataSourceClient(baseConnectionParam, dbType);
        });
        return dataSourceClient.getConnection();
    }

    private void initDataSourcePlugin() {
        this.dataSourcePluginManager = new DataSourcePluginManager();
        this.dataSourcePluginManager.installPlugin();
    }

    private static class DataSourceClientProviderHolder {
        private static final DataSourceClientProvider INSTANCE = new DataSourceClientProvider();

        private DataSourceClientProviderHolder() {
        }
    }
}

