/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.writer;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.WriterConfig;
import org.apache.dolphinscheduler.data.quality.enums.WriterType;
import org.apache.dolphinscheduler.data.quality.exception.DataQualityException;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchWriter;
import org.apache.dolphinscheduler.data.quality.flow.batch.writer.JdbcWriter;
import org.apache.dolphinscheduler.data.quality.flow.batch.writer.file.HdfsFileWriter;
import org.apache.dolphinscheduler.data.quality.flow.batch.writer.file.LocalFileWriter;

public class WriterFactory {
    public static WriterFactory getInstance() {
        return Singleton.instance;
    }

    public List<BatchWriter> getWriters(SparkRuntimeEnvironment sparkRuntimeEnvironment, List<WriterConfig> writerConfigs) throws DataQualityException {
        ArrayList<BatchWriter> writerList = new ArrayList<BatchWriter>();
        for (WriterConfig writerConfig : writerConfigs) {
            BatchWriter writer = this.getWriter(writerConfig);
            if (writer == null) continue;
            writer.validateConfig();
            writer.prepare(sparkRuntimeEnvironment);
            writerList.add(writer);
        }
        return writerList;
    }

    private BatchWriter getWriter(WriterConfig writerConfig) throws DataQualityException {
        WriterType writerType = WriterType.getType(writerConfig.getType());
        Config config = new Config(writerConfig.getConfig());
        if (writerType != null) {
            switch (writerType) {
                case JDBC: {
                    return new JdbcWriter(config);
                }
                case LOCAL_FILE: {
                    return new LocalFileWriter(config);
                }
                case HDFS_FILE: {
                    return new HdfsFileWriter(config);
                }
            }
            throw new DataQualityException("writer type " + (Object)((Object)writerType) + " is not supported!");
        }
        return null;
    }

    private static class Singleton {
        static WriterFactory instance = new WriterFactory();

        private Singleton() {
        }
    }
}

