/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.transformer;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.TransformerConfig;
import org.apache.dolphinscheduler.data.quality.enums.TransformerType;
import org.apache.dolphinscheduler.data.quality.exception.DataQualityException;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchTransformer;
import org.apache.dolphinscheduler.data.quality.flow.batch.transformer.SqlTransformer;

public class TransformerFactory {
    public static TransformerFactory getInstance() {
        return Singleton.instance;
    }

    public List<BatchTransformer> getTransformer(SparkRuntimeEnvironment sparkRuntimeEnvironment, List<TransformerConfig> transformerConfigs) throws DataQualityException {
        ArrayList<BatchTransformer> transformers = new ArrayList<BatchTransformer>();
        for (TransformerConfig transformerConfig : transformerConfigs) {
            BatchTransformer transformer = this.getTransformer(transformerConfig);
            if (transformer == null) continue;
            transformer.validateConfig();
            transformer.prepare(sparkRuntimeEnvironment);
            transformers.add(transformer);
        }
        return transformers;
    }

    private BatchTransformer getTransformer(TransformerConfig transformerConfig) throws DataQualityException {
        TransformerType transformerType = TransformerType.getType(transformerConfig.getType());
        Config config = new Config(transformerConfig.getConfig());
        if (transformerType != null) {
            if (transformerType == TransformerType.SQL) {
                return new SqlTransformer(config);
            }
            throw new DataQualityException("transformer type " + (Object)((Object)transformerType) + " is not supported!");
        }
        return null;
    }

    private static class Singleton {
        static TransformerFactory instance = new TransformerFactory();

        private Singleton() {
        }
    }
}

