/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.reader;

import com.google.common.base.Strings;
import java.util.Arrays;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.ValidateResult;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class HiveReader
implements BatchReader {
    private final Config config;

    public HiveReader(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public ValidateResult validateConfig() {
        return this.validate(Arrays.asList("database", "table"));
    }

    @Override
    public void prepare(SparkRuntimeEnvironment prepareEnv) {
        if (Strings.isNullOrEmpty((String)this.config.getString("sql"))) {
            this.config.put("sql", "select * from " + this.config.getString("database") + "." + this.config.getString("table"));
        }
    }

    @Override
    public Dataset<Row> read(SparkRuntimeEnvironment env) {
        return env.sparkSession().sql(this.config.getString("sql"));
    }
}

