/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.context;

import java.util.List;
import org.apache.dolphinscheduler.data.quality.config.DataQualityConfiguration;
import org.apache.dolphinscheduler.data.quality.exception.DataQualityException;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchReader;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchTransformer;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchWriter;
import org.apache.dolphinscheduler.data.quality.flow.batch.reader.ReaderFactory;
import org.apache.dolphinscheduler.data.quality.flow.batch.transformer.TransformerFactory;
import org.apache.dolphinscheduler.data.quality.flow.batch.writer.WriterFactory;

public class DataQualityContext {
    private SparkRuntimeEnvironment sparkRuntimeEnvironment;
    private DataQualityConfiguration dataQualityConfiguration;

    public DataQualityContext() {
    }

    public DataQualityContext(SparkRuntimeEnvironment sparkRuntimeEnvironment, DataQualityConfiguration dataQualityConfiguration) {
        this.sparkRuntimeEnvironment = sparkRuntimeEnvironment;
        this.dataQualityConfiguration = dataQualityConfiguration;
    }

    public void execute() throws DataQualityException {
        List<BatchReader> readers = ReaderFactory.getInstance().getReaders(this.sparkRuntimeEnvironment, this.dataQualityConfiguration.getReaderConfigs());
        List<BatchTransformer> transformers = TransformerFactory.getInstance().getTransformer(this.sparkRuntimeEnvironment, this.dataQualityConfiguration.getTransformerConfigs());
        List<BatchWriter> writers = WriterFactory.getInstance().getWriters(this.sparkRuntimeEnvironment, this.dataQualityConfiguration.getWriterConfigs());
        if (!this.sparkRuntimeEnvironment.isBatch()) {
            throw new DataQualityException("stream mode is not supported now");
        }
        this.sparkRuntimeEnvironment.getBatchExecution().execute(readers, transformers, writers);
    }
}

