/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.dolphinscheduler.data.quality.config.EnvConfig;
import org.apache.dolphinscheduler.data.quality.config.IConfig;
import org.apache.dolphinscheduler.data.quality.config.ReaderConfig;
import org.apache.dolphinscheduler.data.quality.config.TransformerConfig;
import org.apache.dolphinscheduler.data.quality.config.WriterConfig;

public class DataQualityConfiguration
implements IConfig {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="env")
    private EnvConfig envConfig;
    @JsonProperty(value="readers")
    private List<ReaderConfig> readerConfigs;
    @JsonProperty(value="transformers")
    private List<TransformerConfig> transformerConfigs;
    @JsonProperty(value="writers")
    private List<WriterConfig> writerConfigs;

    public DataQualityConfiguration() {
    }

    public DataQualityConfiguration(String name, EnvConfig envConfig, List<ReaderConfig> readerConfigs, List<WriterConfig> writerConfigs, List<TransformerConfig> transformerConfigs) {
        this.name = name;
        this.envConfig = envConfig;
        this.readerConfigs = readerConfigs;
        this.writerConfigs = writerConfigs;
        this.transformerConfigs = transformerConfigs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnvConfig getEnvConfig() {
        return this.envConfig;
    }

    public void setEnvConfig(EnvConfig envConfig) {
        this.envConfig = envConfig;
    }

    public List<ReaderConfig> getReaderConfigs() {
        return this.readerConfigs;
    }

    public void setReaderConfigs(List<ReaderConfig> readerConfigs) {
        this.readerConfigs = readerConfigs;
    }

    public List<TransformerConfig> getTransformerConfigs() {
        return this.transformerConfigs;
    }

    public void setTransformerConfigs(List<TransformerConfig> transformerConfigs) {
        this.transformerConfigs = transformerConfigs;
    }

    public List<WriterConfig> getWriterConfigs() {
        return this.writerConfigs;
    }

    public void setWriterConfigs(List<WriterConfig> writerConfigs) {
        this.writerConfigs = writerConfigs;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"name should not be empty");
        Preconditions.checkArgument((this.envConfig != null ? 1 : 0) != 0, (Object)"env config should not be empty");
        Preconditions.checkArgument((this.readerConfigs != null ? 1 : 0) != 0, (Object)"reader config should not be empty");
        for (ReaderConfig readerConfig : this.readerConfigs) {
            readerConfig.validate();
        }
        Preconditions.checkArgument((this.transformerConfigs != null ? 1 : 0) != 0, (Object)"transform config should not be empty");
        for (TransformerConfig transformParameter : this.transformerConfigs) {
            transformParameter.validate();
        }
        Preconditions.checkArgument((this.writerConfigs != null ? 1 : 0) != 0, (Object)"writer config should not be empty");
        for (WriterConfig writerConfig : this.writerConfigs) {
            writerConfig.validate();
        }
    }

    public String toString() {
        return "DataQualityConfiguration{name='" + this.name + '\'' + ", envConfig=" + this.envConfig + ", readerConfigs=" + this.readerConfigs + ", transformerConfigs=" + this.transformerConfigs + ", writerConfigs=" + this.writerConfigs + '}';
    }
}

