/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.DataQualityConfiguration;
import org.apache.dolphinscheduler.data.quality.config.EnvConfig;
import org.apache.dolphinscheduler.data.quality.context.DataQualityContext;
import org.apache.dolphinscheduler.data.quality.enums.ReaderType;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQualityApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataQualityApplication.class);

    public static void main(String[] args) throws Exception {
        String dataQualityParameter;
        DataQualityConfiguration dataQualityConfiguration;
        if (args.length < 1) {
            log.error("Can not find DataQualityConfiguration");
            System.exit(-1);
        }
        if ((dataQualityConfiguration = JsonUtils.fromJson(dataQualityParameter = args[0], DataQualityConfiguration.class)) == null) {
            log.info("DataQualityConfiguration is null");
            System.exit(-1);
        } else {
            dataQualityConfiguration.validate();
        }
        EnvConfig envConfig = dataQualityConfiguration.getEnvConfig();
        Config config = new Config(envConfig.getConfig());
        config.put("type", envConfig.getType());
        if (Strings.isNullOrEmpty((String)config.getString("spark.app.name"))) {
            config.put("spark.app.name", dataQualityConfiguration.getName());
        }
        boolean hiveClientSupport = dataQualityConfiguration.getReaderConfigs().stream().anyMatch(line -> line.getType().equalsIgnoreCase(ReaderType.HIVE.name()));
        SparkRuntimeEnvironment sparkRuntimeEnvironment = new SparkRuntimeEnvironment(config, hiveClientSupport);
        DataQualityContext dataQualityContext = new DataQualityContext(sparkRuntimeEnvironment, dataQualityConfiguration);
        dataQualityContext.execute();
    }
}

