/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionFrame;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.gui.SessionsFrame;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.message.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.extended.LaunchDiagnosticUiResponse;
import org.apache.directory.shared.ldap.name.LdapDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchDiagnosticUiHandler
implements ExtendedOperationHandler {
    public static final Set<String> EXTENSION_OIDS;
    private LdapServer ldapServer;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.1";
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, InternalExtendedRequest req) throws Exception {
        DirectoryService service = requestor.getCoreSession().getDirectoryService();
        if (!requestor.getCoreSession().isAnAdministrator()) {
            requestor.getIoSession().write((Object)new LaunchDiagnosticUiResponse(req.getMessageId(), ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS));
            return;
        }
        requestor.getIoSession().write((Object)new LaunchDiagnosticUiResponse(req.getMessageId()));
        PartitionNexus nexus = service.getPartitionNexus();
        LdapDN adminDn = new LdapDN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(service.getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        LdapPrincipal principal = new LdapPrincipal(adminDn, AuthenticationLevel.STRONG);
        CoreSession session = service.getSession(principal);
        Set suffixes = nexus.listSuffixes(new ListSuffixOperationContext(session));
        int launchedWindowCount = 0;
        for (String suffix : suffixes) {
            LdapDN dn = new LdapDN(suffix);
            Partition partition = nexus.getPartition(dn);
            if (!(partition instanceof BTreePartition)) continue;
            try {
                BTreePartition btPartition = (BTreePartition)partition;
                PartitionFrame frame = new PartitionFrame(btPartition, service.getRegistries());
                Point pos = this.getCenteredPosition((JFrame)frame);
                pos.y = launchedWindowCount * 20 + pos.y;
                double multiplier = this.getAspectRatio() * 20.0;
                pos.x = (int)((double)launchedWindowCount * multiplier) + pos.x;
                frame.setLocation(pos);
                frame.setVisible(true);
                ++launchedWindowCount;
            }
            catch (Exception e) {}
        }
        SessionsFrame sessions = new SessionsFrame(this.ldapServer);
        sessions.setRequestor(requestor.getIoSession());
        sessions.setLdapProvider(this.ldapServer.getHandler());
        Point pos = this.getCenteredPosition(sessions);
        pos.y = launchedWindowCount * 20 + pos.y;
        double multiplier = this.getAspectRatio() * 20.0;
        pos.x = (int)((double)launchedWindowCount * multiplier) + pos.x;
        sessions.setLocation(pos);
        sessions.setVisible(true);
    }

    public double getAspectRatio() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        return screenSize.getWidth() / screenSize.getHeight();
    }

    public Point getCenteredPosition(JFrame frame) {
        Point pt = new Point();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        pt.x = (screenSize.width - frame.getWidth()) / 2;
        pt.y = (screenSize.height - frame.getHeight()) / 2;
        return pt;
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
        this.ldapServer = ldapServer;
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("1.3.6.1.4.1.18060.0.1.1");
        set.add("1.3.6.1.4.1.18060.0.1.2");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

