/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.plain;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainSaslServer;
import org.apache.directory.shared.ldap.message.InternalBindRequest;

public class PlainMechanismHandler
extends AbstractMechanismHandler {
    public SaslServer handleMechanism(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            ss = new PlainSaslServer(ldapSession, adminSession, bindRequest);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    public void init(LdapSession ldapSession) {
    }

    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

