/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.gui.OutstandingRequestsModel;
import org.apache.directory.shared.ldap.message.InternalAbandonableRequest;

public class OutstandingRequestsDialog
extends JDialog {
    private static final long serialVersionUID = -3777123348215825711L;
    private static final InternalAbandonableRequest[] EMPTY_REQUEST_ARRAY = new InternalAbandonableRequest[0];
    private JPanel jContentPane;
    private JPanel jPanel;
    private JScrollPane jScrollPane;
    private JTable jTable;
    private JPanel jPanel1;
    private JButton jButton;
    final LdapSession session;
    final LdapServer ldapServer;
    private JPanel jPanel2;
    private JTextArea jTextArea;
    private JButton jButton1;
    private JButton jButton2;

    public OutstandingRequestsDialog(JFrame owner, LdapSession session, LdapServer ldapServer) {
        super((Frame)owner, true);
        this.session = session;
        this.ldapServer = ldapServer;
        StringBuffer buf = new StringBuffer();
        buf.append("Outstanding Requests: ");
        buf.append(((InetSocketAddress)session.getIoSession().getRemoteAddress()).getHostName());
        buf.append(":");
        buf.append(((InetSocketAddress)session.getIoSession().getRemoteAddress()).getPort());
        this.setTitle(buf.toString());
        this.initialize();
    }

    private void initialize() {
        this.setSize(549, 341);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJScrollPane(), "Center");
            this.jPanel.add((Component)this.getJPanel1(), "South");
            this.jPanel.add((Component)this.getJPanel2(), "North");
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        this.setRequestsModel();
        this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row = OutstandingRequestsDialog.this.jTable.getSelectedRow();
                if (row > -1) {
                    OutstandingRequestsDialog.this.jButton2.setEnabled(true);
                    InternalAbandonableRequest req = ((OutstandingRequestsModel)OutstandingRequestsDialog.this.jTable.getModel()).getAbandonableRequest(row);
                    OutstandingRequestsDialog.this.jTextArea.setText(req.toString());
                    OutstandingRequestsDialog.this.jTextArea.setEnabled(true);
                } else {
                    OutstandingRequestsDialog.this.jButton2.setEnabled(false);
                    OutstandingRequestsDialog.this.jTextArea.setText("");
                    OutstandingRequestsDialog.this.jTextArea.setEnabled(false);
                }
            }
        });
        return this.jTable;
    }

    private void setRequestsModel() {
        InternalAbandonableRequest[] requests;
        Map<Integer, InternalAbandonableRequest> reqsMap = this.session.getOutstandingRequests();
        if (reqsMap != null) {
            requests = new InternalAbandonableRequest[reqsMap.size()];
            requests = reqsMap.values().toArray(requests);
        } else {
            requests = EMPTY_REQUEST_ARRAY;
        }
        this.jTable.setModel(new OutstandingRequestsModel(requests));
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getJButton(), null);
            this.jPanel1.add((Component)this.getJButton1(), null);
        }
        return this.jPanel1;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Done");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OutstandingRequestsDialog.this.setVisible(false);
                    OutstandingRequestsDialog.this.dispose();
                }
            });
        }
        return this.jButton;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Request", 0, 0, null, null));
            this.jPanel2.add((Component)this.getJButton2(), "West");
            this.jPanel2.add((Component)this.getJTextArea(), "Center");
        }
        return this.jPanel2;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
        }
        this.jTextArea.setEnabled(false);
        this.jTextArea.setEditable(false);
        return this.jTextArea;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText("Refresh");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OutstandingRequestsDialog.this.setRequestsModel();
                    OutstandingRequestsDialog.this.jTextArea.setText("");
                    OutstandingRequestsDialog.this.jTextArea.setEnabled(false);
                    OutstandingRequestsDialog.this.jButton2.setEnabled(false);
                }
            });
        }
        return this.jButton1;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setText("Abandon");
            this.jButton2.setEnabled(false);
            this.jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = OutstandingRequestsDialog.this.jTable.getSelectedRow();
                    InternalAbandonableRequest req = ((OutstandingRequestsModel)OutstandingRequestsDialog.this.jTable.getModel()).getAbandonableRequest(row);
                    req.abandon();
                    OutstandingRequestsDialog.this.session.abandonOutstandingRequest(req.getMessageId());
                    OutstandingRequestsDialog.this.setRequestsModel();
                }
            });
        }
        return this.jButton2;
    }
}

