/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import org.apache.directory.server.dns.util.EnumConverter;
import org.apache.directory.server.dns.util.ReverseEnumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServiceType implements EnumConverter<Byte>
{
    NULL(0),
    RJE(5),
    ECHO(7),
    DISCARD(9),
    USERS(11),
    DAYTIME(13),
    QUOTE(17),
    CHARGEN(19),
    FTP_DATA(20),
    FTP(21),
    TELNET(23),
    SMTP(25),
    NSW_FE(27),
    MSG_ICP(29),
    MSG_AUTH(31),
    DSP(33),
    TIME(37),
    RLP(39),
    GRAPHICS(41),
    NAMESERVER(42),
    NICKNAME(43),
    MPM_FLAGS(44),
    MPM(45),
    MPM_SND(46),
    NI_FTP(47),
    LOGIN(49),
    LA_MAINT(51),
    DOMAIN(53),
    ISI_GL(55),
    NI_MAIL(61),
    VIA_FTP(63),
    TACACS_DS(65),
    BOOTPS(67),
    BOOTPC(68),
    TFTP(69),
    NETRJS_1(71),
    NETRJS_2(72),
    NETRJS_3(73),
    NETRJS_4(74),
    FINGER(79),
    HOSTS2_NS(81),
    SU_MIT_TG(89),
    MIT_DOV(91),
    DCP(93),
    SUPDUP(95),
    SWIFT_RVF(97),
    TACNEWS(98),
    METAGRAM(99),
    HOSTNAME(101),
    ISO_TSAP(102),
    X400(103),
    X400_SND(104),
    CSNET_NS(105),
    RTELNET(107),
    POP_2(109),
    SUNRPC(111),
    AUTH(113),
    SFTP(115),
    UUCP_PATH(117),
    NNTP(119),
    ERPC(121),
    NTP(123),
    LOCUS_MAP(125),
    LOCUS_CON(127),
    PWDGEN(129),
    CISCO_FNA(130),
    CISCO_TNA(131),
    CISCO_SYS(132),
    STATSRV(133),
    INGRES_NET(134),
    LOC_SRV(135),
    PROFILE(136),
    NETBIOS_NS(137),
    NETBIOS_DGM(138),
    NETBIOS_SSN(139),
    EMFIS_DATA(140),
    EMFIS_CNTL(141),
    BL_IDM(142),
    SUR_MEAS(243),
    LINK(245);

    private static ReverseEnumMap<Byte, ServiceType> map;
    private final byte value;

    private ServiceType(int value) {
        this.value = (byte)value;
    }

    @Override
    public Byte convert() {
        return this.value;
    }

    public static ServiceType convert(byte value) {
        return map.get(value);
    }

    static {
        map = new ReverseEnumMap(ServiceType.class);
    }
}

