/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.components.PaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodData
implements Asn1Object {
    private static final Logger LOG = LoggerFactory.getLogger(MethodData.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private List<PaData> paDatas = new ArrayList<PaData>();
    private int methodDataLength;

    public void addPaData(PaData paData) {
        this.paDatas.add(paData);
    }

    public boolean contains(PaData paData) {
        if (this.paDatas != null) {
            return this.paDatas.contains(paData);
        }
        return false;
    }

    public int hashCode() {
        int hash = 37;
        if (this.paDatas != null) {
            hash = hash * 17 + this.paDatas.size();
            for (PaData paData : this.paDatas) {
                hash = hash * 17 + paData.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(MethodData that) {
        if (that == null) {
            return false;
        }
        if (this.paDatas.size() != that.paDatas.size()) {
            return false;
        }
        for (int i = 0; i < this.paDatas.size(); ++i) {
            if (this.paDatas.get(i).equals(that.paDatas.get(i))) continue;
            return false;
        }
        return true;
    }

    public PaData[] getPaDatas() {
        return this.paDatas.toArray(new PaData[0]);
    }

    public int computeLength() {
        this.methodDataLength = 0;
        if (this.paDatas != null && this.paDatas.size() != 0) {
            for (PaData paData : this.paDatas) {
                int length = paData.computeLength();
                this.methodDataLength += length;
            }
        }
        return 1 + TLV.getNbBytes((int)this.methodDataLength) + this.methodDataLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_148, (Object[])new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.methodDataLength));
            if (this.paDatas != null && this.paDatas.size() != 0) {
                for (PaData paData : this.paDatas) {
                    paData.encode(buffer);
                }
            }
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err((I18n)I18n.ERR_144, (Object[])new Object[]{1 + TLV.getNbBytes((int)this.methodDataLength) + this.methodDataLength, buffer.capacity()}));
            throw new EncoderException(I18n.err((I18n)I18n.ERR_138, (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("METHOD-DATA encoding : {}", (Object)Strings.dumpBytes((byte[])buffer.array()));
            LOG.debug("METHOD-DATA initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        sb.append("METHOD-DATA : ");
        for (PaData paData : this.paDatas) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(paData.toString());
        }
        return sb.toString();
    }
}

