/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.intermediateResponse;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.StringConstants;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreIntermediateResponseValue
extends GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreIntermediateResponseValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreIntermediateResponseValue() {
        super("Store response value");
    }

    @Override
    public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
        IntermediateResponse intermediateResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            intermediateResponse.setResponseValue(StringConstants.EMPTY_BYTES);
        } else {
            intermediateResponse.setResponseValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Value read : {}", (Object)Strings.dumpBytes(intermediateResponse.getResponseValue()));
        }
    }
}

