/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.topologymanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    protected static ServiceReference[] getEndpointListeners(BundleContext bctx) throws InvalidSyntaxException {
        ServiceReference[] refs = bctx.getServiceReferences(EndpointListener.class.getName(), "(endpoint.listener.scope=*)");
        return refs;
    }

    public static List<Filter> normalizeScope(ServiceReference sref, BundleContext bctx) throws InvalidSyntaxException {
        ArrayList<Filter> filters;
        block4: {
            Object fo;
            block5: {
                String[] foArray;
                block3: {
                    filters = new ArrayList<Filter>();
                    fo = sref.getProperty("endpoint.listener.scope");
                    if (!(fo instanceof String)) break block3;
                    filters.add(bctx.createFilter((String)fo));
                    break block4;
                }
                if (!(fo instanceof String[])) break block5;
                for (String f : foArray = (String[])fo) {
                    filters.add(bctx.createFilter(f));
                }
                break block4;
            }
            if (!(fo instanceof Collection)) break block4;
            Collection c = (Collection)fo;
            for (Object o : c) {
                if (o instanceof String) {
                    filters.add(bctx.createFilter((String)o));
                    continue;
                }
                LOG.info("Component of a filter is not a string -> skipped !");
            }
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUUID(BundleContext bctx) {
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String uuid = bctx.getProperty("org.osgi.framework.uuid");
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                System.setProperty("org.osgi.framework.uuid", uuid);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return uuid;
        }
    }

    public static String extendFilter(String filter, BundleContext bctx) {
        return "(&" + filter + "(!(" + "endpoint.framework.uuid" + "=" + Utils.getUUID(bctx) + ")))";
    }
}

