/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.ClassUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ClientServiceFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigTypeHandlerFactory;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.EventProducer;
import org.apache.cxf.dosgi.dsw.service.ExportReferenceImpl;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.dosgi.dsw.service.ImportRegistrationImpl;
import org.apache.cxf.dosgi.dsw.service.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceAdminCore
implements RemoteServiceAdmin {
    private static final Logger LOG = LogUtils.getL7dLogger(RemoteServiceAdminCore.class);
    private final LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> exportedServices = new LinkedHashMap();
    private final LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> importedServices = new LinkedHashMap();
    private BundleContext bctx;
    private EventProducer eventProducer;
    private volatile boolean useMasterMap = true;
    private volatile String defaultPort;
    private volatile String defaultHost;
    protected static final List<String> supportedConfigurationTypes = new ArrayList<String>();
    protected static final String DEFAULT_CONFIGURATION = "org.apache.cxf.ws";

    public RemoteServiceAdminCore(BundleContext bc) {
        this.bctx = bc;
        this.eventProducer = new EventProducer(this.bctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List exportService(ServiceReference serviceReference, Map additionalProperties) throws IllegalArgumentException, UnsupportedOperationException {
        LOG.fine("RemoteServiceAdmin: exportService: " + serviceReference.getClass().getName());
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            String[] keys;
            if (this.exportedServices.containsKey(serviceReference)) {
                LOG.fine("already exported ...  " + serviceReference.getClass().getName());
                Collection<ExportRegistrationImpl> regs = this.exportedServices.get(serviceReference);
                ArrayList<EndpointDescription> copiedEndpoints = new ArrayList<EndpointDescription>();
                ArrayList<ExportRegistrationImpl> copy = new ArrayList<ExportRegistrationImpl>(regs.size());
                for (ExportRegistrationImpl exportRegistration : regs) {
                    if (copiedEndpoints.contains(exportRegistration.getEndpointDescription())) continue;
                    copiedEndpoints.add(exportRegistration.getEndpointDescription());
                    copy.add(new ExportRegistrationImpl(exportRegistration));
                }
                regs.addAll(copy);
                this.eventProducer.publishNotifcation(copy);
                return copy;
            }
            if (this.isCreatedByThisRSA(serviceReference)) {
                LOG.fine("proxy provided by this bundle ...  " + serviceReference.getClass().getName());
                return Collections.EMPTY_LIST;
            }
            Properties serviceProperties = new Properties();
            for (String k : keys = serviceReference.getPropertyKeys()) {
                serviceProperties.put(k, serviceReference.getProperty(k));
            }
            if (additionalProperties != null) {
                Utils.overlayProperties(serviceProperties, additionalProperties);
            }
            String[] requiredIntents = Utils.getAllRequiredIntents(serviceProperties);
            IntentMap im = OsgiUtils.getIntentMap(this.bctx);
            ArrayList<String> unsupportedIntents = new ArrayList<String>();
            for (String ri : requiredIntents) {
                if (im.getIntents().containsKey(ri)) continue;
                unsupportedIntents.add(ri);
            }
            if (unsupportedIntents.size() > 0) {
                LOG.severe("service cannot be exported because the following intents are not supported by this RSA: " + unsupportedIntents);
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> interfaces = new ArrayList<String>(1);
            String[] providedInterfaces = (String[])serviceProperties.get("objectClass");
            String[] allowedInterfaces = Utils.normalizeStringPlus(serviceProperties.get("service.exported.interfaces"));
            if (providedInterfaces == null || allowedInterfaces == null) {
                LOG.severe("export failed: no provided service interfaces found or service_exported_interfaces is null !!");
                return Collections.EMPTY_LIST;
            }
            if (allowedInterfaces.length == 1 && "*".equals(allowedInterfaces[0])) {
                for (String i : providedInterfaces) {
                    interfaces.add(i);
                }
            } else {
                for (String x : allowedInterfaces) {
                    for (String i : providedInterfaces) {
                        if (!x.equals(i)) continue;
                        interfaces.add(i);
                    }
                }
            }
            LOG.info("interfaces selected for export: " + interfaces);
            if (interfaces.size() == 0) {
                LOG.info("no interfaces to be exported");
                return Collections.EMPTY_LIST;
            }
            List<String> configurationTypes = this.determineConfigurationTypes(serviceProperties);
            LOG.info("configuration types selected for export: " + configurationTypes);
            if (configurationTypes.size() == 0) {
                LOG.info("the requested configuration types are not supported");
                return Collections.EMPTY_LIST;
            }
            LinkedHashMap<String, ExportRegistrationImpl> exportRegs = new LinkedHashMap<String, ExportRegistrationImpl>(1);
            for (String iface : interfaces) {
                LOG.info("creating initial ExportDescription for interface " + iface + "  with configuration types " + configurationTypes);
                ExportRegistrationImpl expReg = new ExportRegistrationImpl(serviceReference, null, this);
                exportRegs.put(iface, expReg);
            }
            for (String iface : interfaces) {
                LOG.info("creating server for interface " + iface);
                ExportRegistrationImpl exportRegistration = (ExportRegistrationImpl)exportRegs.get(iface);
                ConfigurationTypeHandler handler = this.getHandler(configurationTypes, serviceProperties, this.getHandlerProperties());
                Object serviceObject = this.bctx.getService(serviceReference);
                BundleContext callingContext = serviceReference.getBundle().getBundleContext();
                if (handler == null) {
                    return Collections.EMPTY_LIST;
                }
                LOG.info("found handler for " + iface + "  -> " + handler);
                String interfaceName = iface;
                Class<?> interfaceClass = ClassUtils.getInterfaceClass(serviceObject, interfaceName);
                if (interfaceClass == null) continue;
                handler.createServer(exportRegistration, this.bctx, callingContext, serviceProperties, interfaceClass, serviceObject);
                if (exportRegistration.getException() == null) {
                    LOG.info("created server for interface " + iface);
                    exportRegistration.startServiceTracker(this.bctx);
                    continue;
                }
                LOG.warning("server creation for interface " + iface + "  failed!");
            }
            this.exportedServices.put(serviceReference, new ArrayList(exportRegs.values()));
            ArrayList<ExportRegistrationImpl> lExpReg = new ArrayList<ExportRegistrationImpl>(exportRegs.values());
            this.eventProducer.publishNotifcation(lExpReg);
            return lExpReg;
        }
    }

    protected List<String> determineConfigurationTypes(Properties serviceProperties) {
        ArrayList<String> configurationTypes = new ArrayList<String>();
        String[] requestedConfigurationTypes = Utils.normalizeStringPlus(serviceProperties.get("service.exported.configs"));
        if (requestedConfigurationTypes == null || requestedConfigurationTypes.length == 0) {
            configurationTypes.add(DEFAULT_CONFIGURATION);
        } else {
            for (String rct : requestedConfigurationTypes) {
                if (!supportedConfigurationTypes.contains(rct)) continue;
                configurationTypes.add(rct);
            }
        }
        return configurationTypes;
    }

    private boolean isCreatedByThisRSA(ServiceReference sref) {
        return sref.getBundle().equals(this.bctx.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getExportedServices() {
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            ArrayList<ExportReferenceImpl> ers = new ArrayList<ExportReferenceImpl>();
            for (Collection<ExportRegistrationImpl> exportRegistrations : this.exportedServices.values()) {
                for (ExportRegistrationImpl er : exportRegistrations) {
                    ers.add(new ExportReferenceImpl(er));
                }
            }
            return Collections.unmodifiableCollection(ers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getImportedEndpoints() {
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            ArrayList<ImportReference> irs = new ArrayList<ImportReference>();
            for (Collection<ImportRegistrationImpl> irl : this.importedServices.values()) {
                for (ImportRegistrationImpl impl : irl) {
                    irs.add(impl.getImportReference());
                }
            }
            return Collections.unmodifiableCollection(irs);
        }
    }

    private ConfigurationTypeHandler getHandler(List<String> configurationTypes, Map serviceProperties, Map<String, Object> props) {
        return ConfigTypeHandlerFactory.getInstance().getHandler(this.bctx, configurationTypes, serviceProperties, props);
    }

    protected Map<String, Object> getHandlerProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("default.port", this.defaultPort == null ? "9000" : this.defaultPort);
        props.put("default.host", this.defaultHost == null ? "localhost" : this.defaultHost);
        props.put("use.master.map", this.useMasterMap);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportRegistration importService(EndpointDescription endpoint) {
        LOG.info("importService() Endpoint: " + endpoint.getProperties());
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            if (this.importedServices.containsKey(endpoint) && this.importedServices.get(endpoint).size() > 0) {
                LOG.fine("creating copy of existing import registrations");
                Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(endpoint);
                ImportRegistrationImpl irParent = imRegs.iterator().next();
                ImportRegistrationImpl ir = new ImportRegistrationImpl(irParent);
                imRegs.add(ir);
                this.eventProducer.publishNotifcation(ir);
                return ir;
            }
            List remoteConfigurationTypes = endpoint.getConfigurationTypes();
            if (remoteConfigurationTypes == null) {
                LOG.severe("the supplied endpoint has no configuration type");
                return null;
            }
            ArrayList<String> usableConfigurationTypes = new ArrayList<String>();
            for (String ct : supportedConfigurationTypes) {
                if (!remoteConfigurationTypes.contains(ct)) continue;
                usableConfigurationTypes.add(ct);
            }
            if (usableConfigurationTypes.size() == 0) {
                LOG.severe("the supplied endpoint has no compatible configuration type. Supported types are: " + supportedConfigurationTypes + "    Types needed by the endpoint: " + remoteConfigurationTypes);
                return null;
            }
            Map emptyProps = Collections.EMPTY_MAP;
            ConfigurationTypeHandler handler = this.getHandler(usableConfigurationTypes, endpoint.getProperties(), emptyProps);
            if (handler == null) {
                LOG.severe("no handler found");
                return null;
            }
            LOG.fine("Handler: " + handler);
            List matchingInterfaces = endpoint.getInterfaces();
            LOG.info("Interfaces: " + matchingInterfaces);
            if (matchingInterfaces.size() == 1) {
                LOG.info("Proxifying interface : " + (String)matchingInterfaces.get(0));
                ImportRegistrationImpl imReg = new ImportRegistrationImpl(endpoint, this);
                this.proxifyMatchingInterface((String)matchingInterfaces.get(0), imReg, handler, this.bctx);
                Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(endpoint);
                if (imRegs == null) {
                    imRegs = new ArrayList<ImportRegistrationImpl>();
                    this.importedServices.put(endpoint, imRegs);
                }
                imRegs.add(imReg);
                this.eventProducer.publishNotifcation(imReg);
                return imReg;
            }
            return null;
        }
    }

    protected void proxifyMatchingInterface(String interfaceName, ImportRegistrationImpl imReg, ConfigurationTypeHandler handler, BundleContext requestingContext) {
        try {
            Class iClass = this.bctx.getBundle().loadClass(interfaceName);
            if (iClass != null) {
                BundleContext actualContext = this.bctx;
                Class actualClass = requestingContext.getBundle().loadClass(interfaceName);
                if (actualClass != iClass) {
                    LOG.info("Class " + interfaceName + " loaded by DSW's bundle context is not " + "equal to the one loaded by the requesting bundle context, " + "DSW will use the requesting bundle context to register " + "a proxy service");
                    iClass = actualClass;
                    actualContext = requestingContext;
                }
                Hashtable<String, Boolean> serviceProps = new Hashtable<String, Boolean>(imReg.getImportedEndpointDescription().getProperties());
                ((Dictionary)serviceProps).put("service.imported", true);
                ((Dictionary)serviceProps).remove("service.exported.interfaces");
                ClientServiceFactory csf = new ClientServiceFactory(actualContext, iClass, imReg.getImportedEndpointDescription(), handler, imReg);
                imReg.setClientServiceFactory(csf);
                ServiceRegistration proxyRegistration = actualContext.registerService(interfaceName, (Object)csf, serviceProps);
                imReg.setImportedServiceRegistration(proxyRegistration);
            } else {
                LOG.info("not proxifying service, cannot load interface class: " + interfaceName);
                imReg.setException(new ClassNotFoundException("not proxifying service, cannot load interface class: " + interfaceName));
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.warning("No class can be found for " + interfaceName);
            imReg.setException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExportRegistration(ExportRegistrationImpl eri) {
        LinkedHashMap<ServiceReference, Collection<ExportRegistrationImpl>> linkedHashMap = this.exportedServices;
        synchronized (linkedHashMap) {
            Collection<ExportRegistrationImpl> exRegs = this.exportedServices.get(eri.getServiceReference());
            if (exRegs != null && exRegs.contains(eri)) {
                exRegs.remove(eri);
            } else {
                LOG.severe("An exportRegistartion was intended to be removed form internal management structure but couldn't be found in it !! ");
            }
            if (exRegs == null || exRegs.size() == 0) {
                this.exportedServices.remove(eri.getServiceReference());
            }
            this.eventProducer.notifyRemoval(eri);
        }
    }

    protected void removeExportRegistrations(BundleContext exportingBundleCtx) {
        Bundle exportingBundle = exportingBundleCtx.getBundle();
        HashMap<ServiceReference, Collection<ExportRegistrationImpl>> exportCopy = new HashMap<ServiceReference, Collection<ExportRegistrationImpl>>(this.exportedServices);
        for (Map.Entry<ServiceReference, Collection<ExportRegistrationImpl>> entry : exportCopy.entrySet()) {
            Bundle regBundle = entry.getKey().getBundle();
            if (!exportingBundle.equals(regBundle)) continue;
            for (ExportRegistrationImpl export : new ArrayList<ExportRegistrationImpl>(entry.getValue())) {
                export.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeImportRegistration(ImportRegistrationImpl iri) {
        LinkedHashMap<EndpointDescription, Collection<ImportRegistrationImpl>> linkedHashMap = this.importedServices;
        synchronized (linkedHashMap) {
            LOG.finest("Removing importRegistration " + iri);
            Collection<ImportRegistrationImpl> imRegs = this.importedServices.get(iri.getImportedEndpointAlways());
            if (imRegs != null && imRegs.contains(iri)) {
                imRegs.remove(iri);
            } else {
                LOG.severe("An importRegistartion was intended to be removed form internal management structure but couldn't be found in it !! ");
            }
            if (imRegs == null || imRegs.size() == 0) {
                this.importedServices.remove(iri.getImportedEndpointAlways());
            }
            this.eventProducer.notifyRemoval(iri);
        }
    }

    static {
        supportedConfigurationTypes.add("wsdl");
        supportedConfigurationTypes.add("org.apache.cxf.rs");
        supportedConfigurationTypes.add(DEFAULT_CONFIGURATION);
        supportedConfigurationTypes.add("pojo");
    }
}

