/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.ClassUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxRSUtils.class);
    public static final String MODEL_FOLDER = "/OSGI-INF/cxf/jaxrs/";
    public static final String DEFAULT_MODEL = "/OSGI-INF/cxf/jaxrs/model.xml";
    public static final String PROVIDERS_FILTER = "(|(objectClass=javax.ws.rs.ext.MessageBodyReader)(objectClass=javax.ws.rs.ext.MessageBodyWriter)(objectClass=javax.ws.rs.ext.ExceptionMapper)(objectClass=org.apache.cxf.jaxrs.ext.RequestHandler)(objectClass=org.apache.cxf.jaxrs.ext.ResponseHandler)(objectClass=org.apache.cxf.jaxrs.ext.ParameterHandler)(objectClass=org.apache.cxf.jaxrs.ext.ResponseExceptionMapper))";

    public static List<Object> getProviders(BundleContext callingContext, BundleContext dswBC, Map sd) {
        boolean globalQueryRequired;
        ArrayList<Object> providers = new ArrayList<Object>();
        if ("aegis".equals(sd.get("org.apache.cxf.rs.databinding"))) {
            providers.add(new AegisElementProvider());
        }
        providers.addAll(ClassUtils.loadProviderClasses(callingContext, sd, "org.apache.cxf.rs.provider"));
        Object globalQueryProp = sd.get("org.apache.cxf.rs.provider.globalquery");
        boolean bl = globalQueryRequired = globalQueryProp == null || OsgiUtils.toBoolean(globalQueryProp);
        if (!globalQueryRequired) {
            return providers;
        }
        boolean cxfProvidersOnly = OsgiUtils.getBooleanProperty(sd, "org.apache.cxf.rs.provider.expected");
        try {
            ServiceReference[] refs = callingContext.getServiceReferences((String)null, PROVIDERS_FILTER);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    if (cxfProvidersOnly && (!cxfProvidersOnly || !OsgiUtils.toBoolean(ref.getProperty("org.apache.cxf.rs.provider")))) continue;
                    providers.add(callingContext.getService(ref));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.fine("Problems finding JAXRS providers " + ex.getMessage());
        }
        return providers;
    }

    public static List<UserResource> getModel(BundleContext callingContext, Class<?> iClass) {
        String classModel = MODEL_FOLDER + iClass.getSimpleName() + "-model.xml";
        List<UserResource> list = JaxRSUtils.getModel(callingContext, iClass, classModel);
        return list != null ? list : JaxRSUtils.getModel(callingContext, iClass, DEFAULT_MODEL);
    }

    public static List<UserResource> getModel(BundleContext callingContext, Class<?> iClass, String name) {
        URL u;
        InputStream r = iClass.getClassLoader().getResourceAsStream(name);
        if (r == null && (u = callingContext.getBundle().getResource(name)) != null) {
            try {
                r = u.openStream();
            }
            catch (Exception ex) {
                LOG.info("Problems opening a user model resource at " + u.toString());
            }
        }
        if (r != null) {
            try {
                return ResourceUtils.getUserResources((InputStream)r);
            }
            catch (Exception ex) {
                LOG.info("Problems reading a user model, it will be ignored");
            }
        }
        return null;
    }
}

