/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.HttpServiceConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.JaxRSUtils;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.UserResource;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRSHttpServiceConfigurationTypeHandler
extends HttpServiceConfigurationTypeHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxRSHttpServiceConfigurationTypeHandler.class);

    protected JaxRSHttpServiceConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) {
        String contextRoot = this.getServletContextRoot(sd, iClass);
        if (contextRoot == null) {
            LOG.warning("Remote address is unavailable");
            return;
        }
        Bus bus = this.registerServletAndGetBus(contextRoot, dswContext, exportRegistration);
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        factory.setBus(bus);
        List<UserResource> resources = JaxRSUtils.getModel(callingContext, iClass);
        if (resources != null) {
            factory.setModelBeansWithServiceClass(resources, new Class[]{iClass});
            factory.setServiceBeanObjects(new Object[]{serviceBean});
        } else {
            factory.setServiceClass(iClass);
            factory.setResourceProvider(iClass, (ResourceProvider)new SingletonResourceProvider(serviceBean));
        }
        factory.setAddress("/");
        List<Object> providers = JaxRSUtils.getProviders(callingContext, dswContext, sd);
        if (providers != null && providers.size() > 0) {
            factory.setProviders(providers);
        }
        this.addRsInterceptorsFeaturesProps((AbstractEndpointFactory)factory, callingContext, sd);
        String address = this.constructAddress(dswContext, contextRoot);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = new String[]{"HTTP"};
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.rs"}, address, intents);
            EndpointDescription endpdDesc = null;
            Thread.currentThread().setContextClassLoader(JAXRSServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            endpdDesc = new EndpointDescription(endpointProps);
            exportRegistration.setServer(server);
            exportRegistration.setEndpointdescription(endpdDesc);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Override
    protected String getServletContextRoot(Map sd, Class<?> iClass) {
        String context = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.httpservice.context");
        if (context == null) {
            context = "/" + iClass.getName().replace('.', '/');
            LOG.info("Using a default address : " + context);
        }
        return context;
    }
}

