/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.handlers.AbstractPojoConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.handlers.SecurityDelegatingHttpContext;
import org.apache.cxf.dosgi.dsw.service.ExportRegistrationImpl;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceConfigurationTypeHandler
extends AbstractPojoConfigurationTypeHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(HttpServiceConfigurationTypeHandler.class);
    Set<ServiceReference> httpServiceReferences = new CopyOnWriteArraySet<ServiceReference>();
    Map<Long, String> exportedAliases = Collections.synchronizedMap(new HashMap());

    protected HttpServiceConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
        ServiceTracker st = new ServiceTracker(dswBC, HttpService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.add(reference);
                return super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                HttpServiceConfigurationTypeHandler.this.httpServiceReferences.remove(reference);
                super.removedService(reference, service);
            }
        };
        st.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createProxy(ServiceReference serviceReference, BundleContext dswContext, BundleContext callingContext, Class<?> iClass, EndpointDescription sd) {
        String address = this.getHttpServiceAddress(sd.getProperties(), iClass);
        if (address == null) {
            LOG.warning("Remote address is unavailable");
            return null;
        }
        LOG.info("Creating a " + iClass.getName() + " client, endpoint address is " + address);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object proxy;
            String dataBindingImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.databinding");
            Object databinding = "jaxb".equals(dataBindingImpl) ? new JAXBDataBinding() : new AegisDatabinding();
            String frontEndImpl = (String)serviceReference.getProperty("org.apache.cxf.ws.frontend");
            ClientProxyFactoryBean factory = this.createClientProxyFactoryBean(frontEndImpl);
            this.addWsInterceptorsFeaturesProps((AbstractEndpointFactory)factory.getClientFactoryBean(), callingContext, sd.getProperties());
            this.setClientWsdlProperties(factory.getClientFactoryBean(), dswContext, sd.getProperties(), false);
            factory.setServiceClass(iClass);
            factory.setAddress(address);
            factory.getServiceFactory().setDataBinding((DataBinding)databinding);
            this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory.getClientFactoryBean(), sd.getProperties());
            Thread.currentThread().setContextClassLoader(ClientProxyFactoryBean.class.getClassLoader());
            Object object = proxy = this.getProxy(factory.create(), iClass);
            return object;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "proxy creation failed", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createServer(ExportRegistrationImpl exportRegistration, BundleContext dswContext, BundleContext callingContext, Map sd, Class<?> iClass, Object serviceBean) {
        String contextRoot = this.getServletContextRoot(sd, iClass);
        if (contextRoot == null) {
            LOG.warning("Remote address is unavailable");
            return;
        }
        Bus bus = this.registerServletAndGetBus(contextRoot, dswContext, exportRegistration);
        ServiceReference sref = exportRegistration.getExportedService();
        String dataBindingImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.databinding");
        String dataBindingImpl2 = (String)sref.getProperty("org.apache.cxf.ws.databinding");
        Object databinding = "jaxb".equals(dataBindingImpl) || "jaxb".equals(dataBindingImpl2) ? new JAXBDataBinding() : new AegisDatabinding();
        String frontEndImpl = (String)exportRegistration.getExportedService().getProperty("org.apache.cxf.ws.frontend");
        String frontEndImpl2 = (String)sref.getProperty("org.apache.cxf.ws.frontend");
        ServerFactoryBean factory = this.createServerFactoryBean(frontEndImpl != null ? frontEndImpl : frontEndImpl2);
        String address = this.constructAddress(dswContext, contextRoot);
        factory.setBus(bus);
        factory.setServiceClass(iClass);
        factory.setAddress("/");
        factory.getServiceFactory().setDataBinding((DataBinding)databinding);
        factory.setServiceBean(serviceBean);
        this.addWsInterceptorsFeaturesProps((AbstractEndpointFactory)factory, callingContext, sd);
        this.setWsdlProperties(factory, dswContext, sd, false);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String[] intents = this.applyIntents(dswContext, callingContext, factory.getFeatures(), (AbstractEndpointFactory)factory, sd);
            Map<String, Object> endpointProps = this.createEndpointProps(sd, iClass, new String[]{"org.apache.cxf.ws"}, address, intents);
            EndpointDescription endpdDesc = null;
            Thread.currentThread().setContextClassLoader(ServerFactoryBean.class.getClassLoader());
            Server server = factory.create();
            endpdDesc = new EndpointDescription(endpointProps);
            exportRegistration.setServer(server);
            exportRegistration.setEndpointdescription(endpdDesc);
        }
        catch (IntentUnsatifiedException iue) {
            exportRegistration.setException(iue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected Bus registerServletAndGetBus(String contextRoot, BundleContext dswContext, ExportRegistrationImpl exportRegistration) {
        CXFNonSpringServlet cxf = new CXFNonSpringServlet();
        HttpService httpService = this.getHttpService();
        try {
            httpService.registerServlet(contextRoot, (Servlet)cxf, new Hashtable(), this.getHttpContext(dswContext, httpService));
            this.registerUnexportHook(exportRegistration, contextRoot);
            LOG.info("Successfully registered CXF DOSGi servlet at " + contextRoot);
        }
        catch (Exception e) {
            throw new ServiceException("CXF DOSGi: problem registering CXF HTTP Servlet", (Throwable)e);
        }
        return cxf.getBus();
    }

    protected String constructAddress(BundleContext ctx, String contextRoot) {
        String port = null;
        boolean https = false;
        if ("true".equalsIgnoreCase(ctx.getProperty("org.osgi.service.http.secure.enabled"))) {
            https = true;
            port = ctx.getProperty("org.osgi.service.http.port.secure");
        } else {
            port = ctx.getProperty("org.osgi.service.http.port");
        }
        if (port == null) {
            port = "8080";
        }
        String hostName = null;
        try {
            hostName = AbstractConfigurationHandler.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return this.getAddress(https ? "https" : "http", hostName, port, contextRoot);
    }

    protected HttpService getHttpService() {
        for (ServiceReference sr : this.httpServiceReferences) {
            Object svc = this.bundleContext.getService(sr);
            if (!(svc instanceof HttpService)) continue;
            return (HttpService)svc;
        }
        throw new ServiceException("CXF DOSGi: No HTTP Service could be found to publish CXF endpoint in.");
    }

    protected String getServletContextRoot(Map sd, Class<?> iClass) {
        String context = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.httpservice.context");
        if (context == null) {
            context = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.httpservice.context");
        }
        if (context == null) {
            context = OsgiUtils.getProperty(sd, "osgi.remote.configuration.wsdl.httpservice.context");
        }
        if (context == null) {
            context = "/" + iClass.getName().replace('.', '/');
            LOG.info("Using a default address : " + context);
        }
        return context;
    }

    protected HttpContext getHttpContext(BundleContext bundleContext, HttpService httpService) {
        HttpContext httpContext = httpService.createDefaultHttpContext();
        return new SecurityDelegatingHttpContext(bundleContext, httpContext);
    }

    protected String getHttpServiceAddress(Map sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "endpoint.id");
        if (address == null && sd.get("endpoint.id") != null) {
            LOG.severe("Could not use address property endpoint.id");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.address");
        }
        if (address == null && sd.get("org.apache.cxf.ws.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.ws.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address");
        }
        if (address == null && sd.get("osgi.remote.configuration.pojo.address") != null) {
            LOG.severe("Could not use address property osgi.remote.configuration.pojo.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        }
        if (address == null && sd.get("org.apache.cxf.rs.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.rs.address");
            return null;
        }
        return address;
    }

    protected void registerUnexportHook(ExportRegistrationImpl export, String alias) {
        ServiceReference sref = export.getExportedService();
        Long sid = (Long)sref.getProperty("service.id");
        LOG.log(Level.FINE, "Registering service listener for service with ID {0}", sid);
        String previous = this.exportedAliases.put(sid, alias);
        if (previous != null) {
            LOG.log(Level.WARNING, "Overwriting service export for service with ID {0}", sid);
        }
        try {
            Filter f = this.bundleContext.createFilter("(service.id=" + sid + ")");
            if (f != null) {
                this.bundleContext.addServiceListener(new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                        if (event.getType() == 4) {
                            ServiceReference sref = event.getServiceReference();
                            Long sid = (Long)sref.getProperty("service.id");
                            String alias = HttpServiceConfigurationTypeHandler.this.exportedAliases.remove(sid);
                            if (alias != null) {
                                LOG.log(Level.FINE, "Unexporting HTTP servlet for alias ''{0}''...", alias);
                                HttpService http = HttpServiceConfigurationTypeHandler.this.getHttpService();
                                if (http != null) {
                                    try {
                                        http.unregister(alias);
                                    }
                                    catch (Exception e) {
                                        LOG.log(Level.WARNING, "An exception occurred while unregistering service for HTTP servlet alias '" + alias + "'", e);
                                    }
                                } else {
                                    LOG.log(Level.WARNING, "Unable to unexport HTTP servlet for alias ''{0}'': no HTTP service available", alias);
                                }
                            } else {
                                LOG.log(Level.WARNING, "Unable to unexport HTTP servlet for service class ''{0}'', service-id {1}: no servlet alias found", new Object[]{sref.getProperty("objectClass"), sid});
                            }
                        }
                    }
                }, f.toString());
            } else {
                LOG.warning("Service listener could not be started. The service will not be automatically unexported.");
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.log(Level.WARNING, "Service listener could not be started. The service will not be automatically unexported.", e);
        }
    }
}

