/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.dosgi.dsw.ClassUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.AbstractConfigurationHandler;
import org.apache.cxf.dosgi.dsw.handlers.IntentUnsatifiedException;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPojoConfigurationTypeHandler
extends AbstractConfigurationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractPojoConfigurationTypeHandler.class);
    private static final String PROVIDED_INTENT_VALUE = "PROVIDED";
    private static final String CONFIGURATION_TYPE = "org.apache.cxf.ws";
    private IntentMap masterMap;

    public AbstractPojoConfigurationTypeHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        super(dswBC, handlerProps);
    }

    ClientProxyFactoryBean createClientProxyFactoryBean(String frontEndImpl) {
        if ("jaxws".equals(frontEndImpl)) {
            return new JaxWsProxyFactoryBean();
        }
        return new ClientProxyFactoryBean();
    }

    ServerFactoryBean createServerFactoryBean(String frontEndImpl) {
        if ("jaxws".equals(frontEndImpl)) {
            return new JaxWsServerFactoryBean();
        }
        return new ServerFactoryBean();
    }

    String[] applyIntents(BundleContext dswContext, BundleContext callingContext, List<AbstractFeature> features, AbstractEndpointFactory factory, Map sd) throws IntentUnsatifiedException {
        String[] requestedIntents = AbstractPojoConfigurationTypeHandler.getRequestedIntents(sd);
        HashSet<String> appliedIntents = new HashSet<String>(Arrays.asList(requestedIntents));
        IntentMap intentMap = this.getIntentMap(callingContext);
        if (this.useMasterMap()) {
            intentMap = this.mergeWithMaster(dswContext, intentMap);
        }
        appliedIntents.addAll(this.reverseLookup(intentMap, PROVIDED_INTENT_VALUE));
        boolean bindingConfigAdded = false;
        for (String requestedName : requestedIntents) {
            bindingConfigAdded |= this.processIntent(appliedIntents, features, factory, requestedName, intentMap);
        }
        if (!bindingConfigAdded && this.getDefaultBindingIntent() != null) {
            this.processIntent(appliedIntents, features, factory, this.getDefaultBindingIntent(), intentMap);
        }
        appliedIntents.addAll(this.addSynonymIntents(appliedIntents, intentMap));
        return appliedIntents.toArray(new String[0]);
    }

    protected void setWsdlProperties(ServerFactoryBean factory, BundleContext dswContext, Map sd, boolean wsdlType) {
        String location = OsgiUtils.getProperty(sd, wsdlType ? "osgi.remote.configuration.wsdl.location" : "org.apache.cxf.ws.location");
        if (location != null) {
            QName serviceName;
            URL wsdlURL = dswContext.getBundle().getResource(location);
            if (wsdlURL != null) {
                factory.setWsdlURL(wsdlURL.toString());
            }
            if ((serviceName = this.getServiceQName(null, sd, wsdlType ? "osgi.remote.configuration.wsdl.service.ns" : "org.apache.cxf.ws.service.ns", wsdlType ? "osgi.remote.configuration.wsdl.service.name" : "org.apache.cxf.ws.service.name")) != null) {
                factory.setServiceName(serviceName);
                QName portName = this.getPortQName(serviceName.getNamespaceURI(), sd, wsdlType ? "osgi.remote.configuration.wsdl.port.name" : "org.apache.cxf.ws.port.name");
                if (portName != null) {
                    factory.setEndpointName(portName);
                }
            }
        }
    }

    protected void addWsInterceptorsFeaturesProps(AbstractEndpointFactory factory, BundleContext callingContext, Map sd) {
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.ws.in.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.ws.out.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.ws.out.fault.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.ws.in.fault.interceptors");
        this.addFeatures(factory, callingContext, sd, "org.apache.cxf.ws.features");
        this.addContextProperties(factory, callingContext, sd, "org.apache.cxf.ws.context.properties");
    }

    protected void addRsInterceptorsFeaturesProps(AbstractEndpointFactory factory, BundleContext callingContext, Map sd) {
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.rs.in.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.rs.out.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.rs.out.fault.interceptors");
        this.addInterceptors(factory, callingContext, sd, "org.apache.cxf.rs.in.fault.interceptors");
        this.addFeatures(factory, callingContext, sd, "org.apache.cxf.rs.features");
        this.addContextProperties(factory, callingContext, sd, "org.apache.cxf.rs.context.properties");
    }

    protected void setClientWsdlProperties(ClientFactoryBean factory, BundleContext dswContext, Map sd, boolean wsdlType) {
        String location = OsgiUtils.getProperty(sd, wsdlType ? "osgi.remote.configuration.wsdl.location" : "org.apache.cxf.ws.location");
        if (location != null) {
            QName serviceName;
            URL wsdlURL = dswContext.getBundle().getResource(location);
            if (wsdlURL != null) {
                factory.setWsdlURL(wsdlURL.toString());
            }
            if ((serviceName = this.getServiceQName(null, sd, wsdlType ? "osgi.remote.configuration.wsdl.service.ns" : "org.apache.cxf.ws.service.ns", wsdlType ? "osgi.remote.configuration.wsdl.service.name" : "org.apache.cxf.ws.service.name")) != null) {
                factory.setServiceName(serviceName);
                QName portName = this.getPortQName(serviceName.getNamespaceURI(), sd, wsdlType ? "osgi.remote.configuration.wsdl.port.name" : "org.apache.cxf.ws.port.name");
                if (portName != null) {
                    factory.setEndpointName(portName);
                }
            }
        }
    }

    protected QName getServiceQName(Class<?> iClass, Map sd, String nsPropName, String namePropName) {
        String serviceNs = OsgiUtils.getProperty(sd, nsPropName);
        String serviceName = OsgiUtils.getProperty(sd, namePropName);
        if (iClass == null && (serviceNs == null || serviceName == null)) {
            return null;
        }
        if (serviceNs == null) {
            serviceNs = PackageUtils.getNamespace((String)PackageUtils.getPackageName(iClass));
        }
        if (serviceName == null) {
            serviceName = iClass.getSimpleName();
        }
        return new QName(serviceNs, serviceName);
    }

    protected QName getPortQName(String ns, Map sd, String propName) {
        String portName = OsgiUtils.getProperty(sd, propName);
        if (portName == null) {
            return null;
        }
        return new QName(ns, portName);
    }

    protected void addInterceptors(AbstractEndpointFactory factory, BundleContext callingContext, Map sd, String propName) {
        List<Object> providers = ClassUtils.loadProviderClasses(callingContext, sd, propName);
        boolean in = propName.contains("in.interceptors");
        boolean out = propName.contains("out.interceptors");
        boolean in_fault = propName.contains("in.fault.interceptors");
        boolean out_fault = propName.contains("out.fault.interceptors");
        for (int i = 0; i < providers.size(); ++i) {
            Interceptor interceptor = (Interceptor)providers.get(i);
            if (in) {
                factory.getInInterceptors().add(interceptor);
                continue;
            }
            if (out) {
                factory.getOutInterceptors().add(interceptor);
                continue;
            }
            if (in_fault) {
                factory.getInFaultInterceptors().add(interceptor);
                continue;
            }
            if (!out_fault) continue;
            factory.getOutFaultInterceptors().add(interceptor);
        }
    }

    protected void addFeatures(AbstractEndpointFactory factory, BundleContext callingContext, Map sd, String propName) {
        List<Object> providers = ClassUtils.loadProviderClasses(callingContext, sd, propName);
        if (providers.size() > 0) {
            factory.getFeatures().addAll(CastUtils.cast(providers, AbstractFeature.class));
        }
    }

    protected void addContextProperties(AbstractEndpointFactory factory, BundleContext callingContext, Map sd, String propName) {
        Map props = (Map)sd.get(propName);
        if (props != null) {
            factory.getProperties(true).putAll(props);
        }
    }

    private boolean processIntent(Set<String> appliedIntents, List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        boolean rc = this.processIntent(features, factory, intentName, intentMap);
        appliedIntents.add(intentName);
        return rc;
    }

    private boolean processIntent(List<AbstractFeature> features, AbstractEndpointFactory factory, String intentName, IntentMap intentMap) throws IntentUnsatifiedException {
        Object intent = intentMap.get(intentName);
        if (intent instanceof String) {
            if (PROVIDED_INTENT_VALUE.equalsIgnoreCase((String)intent)) {
                return false;
            }
        } else {
            if (intent instanceof AbstractFeature) {
                AbstractFeature feature = (AbstractFeature)intent;
                LOG.info("Applying intent: " + intentName + " via feature: " + feature);
                features.add(feature);
                return false;
            }
            if (intent instanceof BindingConfiguration) {
                BindingConfiguration bindingCfg = (BindingConfiguration)intent;
                LOG.info("Applying intent: " + intentName + " via binding config: " + bindingCfg);
                factory.setBindingConfig(bindingCfg);
                return true;
            }
            LOG.info("No mapping for intent: " + intentName);
            throw new IntentUnsatifiedException(intentName);
        }
        return false;
    }

    private Collection<String> addSynonymIntents(Collection<String> appliedIntents, IntentMap intentMap) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : appliedIntents) {
            values.add(intentMap.get(key));
        }
        return this.reverseLookup(intentMap, values);
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Object obj) {
        return this.reverseLookup(intentMap, Collections.singleton(obj));
    }

    private Collection<String> reverseLookup(IntentMap intentMap, Collection<? extends Object> objs) {
        HashSet<String> intentsFound = new HashSet<String>();
        for (Map.Entry<String, Object> entry : intentMap.getIntents().entrySet()) {
            if (!objs.contains(entry.getValue())) continue;
            intentsFound.add(entry.getKey());
        }
        return intentsFound;
    }

    String getDefaultBindingIntent() {
        return "SOAP";
    }

    IntentMap getIntentMap(BundleContext callingContext) {
        return OsgiUtils.getIntentMap(callingContext);
    }

    @Override
    public String getType() {
        return CONFIGURATION_TYPE;
    }

    private static String[] getRequestedIntents(Map sd) {
        List<String> intents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "service.exported.intents")));
        List<String> extraIntents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "service.exported.intents")));
        List<String> oldIntents = Arrays.asList(OsgiUtils.parseIntents(OsgiUtils.getProperty(sd, "osgi.remote.requires.intents")));
        HashSet<String> allIntents = new HashSet<String>(intents.size() + extraIntents.size() + oldIntents.size());
        allIntents.addAll(intents);
        allIntents.addAll(extraIntents);
        allIntents.addAll(oldIntents);
        LOG.fine("Intents asserted: " + allIntents);
        return allIntents.toArray(new String[allIntents.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntentMap mergeWithMaster(BundleContext dswContext, IntentMap intentMap) {
        AbstractPojoConfigurationTypeHandler abstractPojoConfigurationTypeHandler = this;
        synchronized (abstractPojoConfigurationTypeHandler) {
            if (this.masterMap == null) {
                LOG.fine("Loading master intent map");
                this.masterMap = this.getIntentMap(dswContext);
            }
        }
        if (this.masterMap != null) {
            for (String masterKey : this.masterMap.getIntents().keySet()) {
                if (intentMap.get(masterKey) == null) {
                    LOG.fine("Merging in master intent map entry: " + masterKey);
                    intentMap.getIntents().put(masterKey, this.masterMap.get(masterKey));
                    continue;
                }
                LOG.fine("Overridden master intent map entry: " + masterKey);
            }
        }
        return intentMap;
    }

    protected String getPojoAddress(Map sd, Class<?> iClass) {
        String address = OsgiUtils.getProperty(sd, "endpoint.id");
        if (address == null && sd.get("endpoint.id") != null) {
            LOG.severe("Could not use address property endpoint.id");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.ws.address");
        }
        if (address == null && sd.get("org.apache.cxf.ws.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.ws.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "osgi.remote.configuration.pojo.address");
        }
        if (address == null && sd.get("osgi.remote.configuration.pojo.address") != null) {
            LOG.severe("Could not use address property osgi.remote.configuration.pojo.address");
            return null;
        }
        if (address == null) {
            address = OsgiUtils.getProperty(sd, "org.apache.cxf.rs.address");
        }
        if (address == null && sd.get("org.apache.cxf.rs.address") != null) {
            LOG.severe("Could not use address property org.apache.cxf.rs.address");
            return null;
        }
        if (address == null) {
            String port = null;
            Object p = sd.get("org.apache.cxf.ws.port");
            if (p instanceof String) {
                port = (String)p;
            }
            if ((address = this.getDefaultAddress(iClass, port)) != null) {
                LOG.info("Using a default address : " + address);
            }
        }
        return address;
    }
}

