/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw.handlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.handlers.ConfigurationTypeHandler;
import org.apache.cxf.dosgi.dsw.handlers.ServiceInvocationHandler;
import org.apache.cxf.dosgi.dsw.service.Utils;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationHandler
implements ConfigurationTypeHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractConfigurationHandler.class);
    final Map<String, Object> handlerProps;
    protected BundleContext bundleContext;

    protected AbstractConfigurationHandler(BundleContext dswBC, Map<String, Object> handlerProps) {
        this.bundleContext = dswBC;
        this.handlerProps = handlerProps;
    }

    protected String getDefaultAddress(Class<?> type) {
        return this.getDefaultAddress(type, null);
    }

    protected String getDefaultAddress(Class<?> type, String port) {
        Object h = this.handlerProps.get("default.host");
        if (h == null || h.toString().equals("localhost")) {
            try {
                h = AbstractConfigurationHandler.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                h = "localhost";
            }
            if (h == null) {
                h = "localhost";
            }
        }
        String host = h.toString();
        if (port == null) {
            Object p = this.handlerProps.get("default.port");
            if (p == null) {
                p = "9000";
            }
            port = p.toString();
        }
        return this.getAddress("http", host, port, "/" + type.getName().replace('.', '/'));
    }

    protected String getAddress(String scheme, String host, String port, String context) {
        StringBuilder buf = new StringBuilder();
        buf.append(scheme).append("://").append(host).append(':').append(port).append(context);
        return buf.toString();
    }

    protected boolean useMasterMap() {
        Object value = this.handlerProps.get("use.master.map");
        if (value == null) {
            return true;
        }
        return OsgiUtils.toBoolean(value);
    }

    protected Object getProxy(Object serviceProxy, Class<?> iType) {
        return Proxy.newProxyInstance(iType.getClassLoader(), new Class[]{iType}, (InvocationHandler)new ServiceInvocationHandler(serviceProxy, iType));
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected Map<String, Object> createEndpointProps(Map sd, Class<?> iClass, String[] importedConfigs, String address, String[] intents) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.copyEndpointProperties(sd, props);
        String[] sa = new String[]{iClass.getName()};
        String pkg = iClass.getPackage().getName();
        props.remove("service.id");
        props.put("objectClass", sa);
        props.put("endpoint.service.id", sd.get("service.id"));
        props.put("endpoint.framework.uuid", OsgiUtils.getUUID(this.getBundleContext()));
        props.put("service.imported.configs", importedConfigs);
        props.put("endpoint.package.version." + pkg, OsgiUtils.getVersion(iClass, this.getBundleContext()));
        for (String configurationType : importedConfigs) {
            if ("org.apache.cxf.ws".equals(configurationType)) {
                props.put("org.apache.cxf.ws.address", address);
                continue;
            }
            if ("org.apache.cxf.rs".equals(configurationType)) {
                props.put("org.apache.cxf.rs.address", address);
                continue;
            }
            if (!"pojo".equals(configurationType)) continue;
            props.put("osgi.remote.configuration.pojo.address", address);
            props.put("org.apache.cxf.ws.address", address);
        }
        String[] allIntents = Utils.mergeArrays(intents, Utils.getInetntsImplementedByTheService(sd));
        props.put("service.intents", allIntents);
        this.addAddressProperty(props, address);
        return props;
    }

    private void copyEndpointProperties(Map sd, Map<String, Object> endpointProps) {
        Set keys = sd.entrySet();
        for (Map.Entry entry : keys) {
            try {
                String skey = (String)entry.getKey();
                if (skey.startsWith(".")) continue;
                endpointProps.put(skey, entry.getValue());
            }
            catch (ClassCastException e) {
                LOG.warning("ServiceProperties Map contained non String key. Skipped  " + entry + "   " + e.getLocalizedMessage());
            }
        }
    }

    protected void addAddressProperty(Map props, String address) {
        if (props != null) {
            props.put("endpoint.id", address);
        }
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        if (!localHost.isLoopbackAddress()) {
            return localHost;
        }
        InetAddress[] addrs = AbstractConfigurationHandler.getAllLocalUsingNetworkInterface();
        for (int i = 0; i < addrs.length; ++i) {
            if (addrs[i].isLoopbackAddress() || addrs[i].getHostAddress().contains(":")) continue;
            return addrs[i];
        }
        return localHost;
    }

    public static InetAddress[] getAllLocal() throws UnknownHostException {
        InetAddress[] iAddresses = InetAddress.getAllByName("127.0.0.1");
        if (iAddresses.length != 1) {
            return iAddresses;
        }
        if (!iAddresses[0].isLoopbackAddress()) {
            return iAddresses;
        }
        return AbstractConfigurationHandler.getAllLocalUsingNetworkInterface();
    }

    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }
}

