/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ClassUtils.class);

    private ClassUtils() {
    }

    public static Class<?> getInterfaceClass(Object service, String interfaceName) {
        return ClassUtils.getInterfaceClass(service.getClass(), interfaceName);
    }

    private static Class<?> getInterfaceClass(Class<?> serviceClass, String interfaceName) {
        for (Class<?> iClass : serviceClass.getInterfaces()) {
            if (iClass.getName().equals(interfaceName)) {
                return iClass;
            }
            Class<?> intf = ClassUtils.getInterfaceClass(iClass, interfaceName);
            if (intf == null) continue;
            return intf;
        }
        if (serviceClass.getName().equals(interfaceName)) {
            return serviceClass;
        }
        Class<?> interfaceOnProxiedClass = ClassUtils.getInterfaceClassOnSuperClasses(serviceClass, interfaceName);
        if (interfaceOnProxiedClass != null) {
            return interfaceOnProxiedClass;
        }
        return null;
    }

    private static Class<?> getInterfaceClassOnSuperClasses(Class<?> serviceClass, String interfaceName) {
        Class<?> superClass = serviceClass.getSuperclass();
        if (superClass != null) {
            for (Class<?> iClass : superClass.getInterfaces()) {
                if (iClass.getName().equals(interfaceName)) {
                    return iClass;
                }
                Class<?> intf = ClassUtils.getInterfaceClass(iClass, interfaceName);
                if (intf == null) continue;
                return intf;
            }
            Class<?> foundOnSuperclass = ClassUtils.getInterfaceClassOnSuperClasses(superClass, interfaceName);
            if (foundOnSuperclass != null) {
                return foundOnSuperclass;
            }
        }
        return null;
    }

    public static List<Object> loadProviderClasses(BundleContext callingContext, Map sd, String propName) {
        Object serviceProviders = sd.get(propName);
        if (serviceProviders != null) {
            if (serviceProviders.getClass().isArray()) {
                if (serviceProviders.getClass().getComponentType() == String.class) {
                    return ClassUtils.loadProviders(callingContext, (String[])serviceProviders);
                }
                return Arrays.asList((Object[])serviceProviders);
            }
            if (serviceProviders.getClass() == String.class) {
                String[] classNames = serviceProviders.toString().split(",");
                return ClassUtils.loadProviders(callingContext, classNames);
            }
            return Arrays.asList(serviceProviders);
        }
        return Collections.emptyList();
    }

    private static List<Object> loadProviders(BundleContext callingContext, String[] classNames) {
        ArrayList<Object> providers = new ArrayList<Object>();
        for (String className : classNames) {
            try {
                String realName = className.trim();
                if (realName.length() <= 0) continue;
                Class pClass = callingContext.getBundle().loadClass(realName);
                providers.add(pClass.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOG.warning("Provider " + className.trim() + " can not be loaded or created");
            }
        }
        return providers;
    }
}

