/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.dsw;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.dosgi.dsw.OsgiUtils;
import org.apache.cxf.dosgi.dsw.decorator.ServiceDecorator;
import org.apache.cxf.dosgi.dsw.decorator.ServiceDecoratorImpl;
import org.apache.cxf.dosgi.dsw.qos.IntentMap;
import org.apache.cxf.dosgi.dsw.service.RemoteServiceadminFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.springframework.osgi.context.BundleContextAware;

public class Activator
implements ManagedService,
BundleContextAware {
    private static final Logger LOG = LogUtils.getL7dLogger(Activator.class);
    private static final String CONFIG_SERVICE_PID = "cxf-dsw";
    private BundleContext bc;
    private ServiceRegistration rsaFactoryReg;
    private ServiceRegistration decoratorReg;

    public synchronized void start() {
        System.setProperty("org.apache.cxf.nofastinfoset", "true");
        this.registerRemoteServiceAdminService();
        this.decoratorReg = this.bc.registerService(ServiceDecorator.class.getName(), (Object)new ServiceDecoratorImpl(this.bc), null);
    }

    private RemoteServiceadminFactory registerRemoteServiceAdminService() {
        RemoteServiceadminFactory rsaf = new RemoteServiceadminFactory(this.bc);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] supportedIntents = this.getIntentMap().getIntents().keySet().toArray(new String[0]);
        String siString = OsgiUtils.formatIntents(supportedIntents);
        props.put("remote.intents.supported", siString);
        String[] supportedConfigs = new String[]{"org.apache.cxf.ws", "pojo", "org.apache.cxf.rs"};
        props.put("remote.configs.supported", supportedConfigs);
        LOG.info("Registering RemoteServiceAdminFactory...");
        this.rsaFactoryReg = this.bc.registerService(RemoteServiceAdmin.class.getName(), (Object)rsaf, props);
        return rsaf;
    }

    IntentMap getIntentMap() {
        return OsgiUtils.getIntentMap(this.bc);
    }

    private Object getHeader(String key) {
        Object value = this.bc.getBundle().getHeaders().get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void stop() {
        LOG.fine("RemoteServiceAdmin Implementation is shutting down now");
        this.rsaFactoryReg.unregister();
        this.decoratorReg.unregister();
        Bus b = BusFactory.getDefaultBus();
        if (b != null) {
            LOG.fine("Shutting down the CXF Bus");
            b.shutdown(true);
        }
    }

    public synchronized void updated(Dictionary props) throws ConfigurationException {
        if (props == null || CONFIG_SERVICE_PID.equals(props.get("service.pid"))) {
            // empty if block
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bc = bundleContext;
    }
}

