/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.local.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.local.LocalDiscoveryUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDiscovery
implements BundleListener {
    private static final Logger LOG = Logger.getLogger(LocalDiscovery.class.getName());
    ConcurrentHashMap<EndpointDescription, Bundle> endpointDescriptions = new ConcurrentHashMap();
    Map<EndpointListener, Collection<String>> listenerToFilters = new HashMap<EndpointListener, Collection<String>>();
    Map<String, Collection<EndpointListener>> filterToListeners = new HashMap<String, Collection<EndpointListener>>();
    final BundleContext bundleContext;
    ServiceTracker listenerTracker;

    public LocalDiscovery(BundleContext bc) {
        this.bundleContext = bc;
        this.listenerTracker = new ServiceTracker(this.bundleContext, EndpointListener.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object svc = super.addingService(reference);
                LocalDiscovery.this.registerTracker(reference, svc);
                return svc;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                super.modifiedService(reference, service);
                LocalDiscovery.this.clearTracker(service);
                LocalDiscovery.this.registerTracker(reference, service);
            }

            public void removedService(ServiceReference reference, Object service) {
                super.removedService(reference, service);
                LocalDiscovery.this.clearTracker(service);
            }
        };
        this.listenerTracker.open();
        this.bundleContext.addBundleListener((BundleListener)this);
        this.processExistingBundles();
    }

    private void processExistingBundles() {
        Bundle[] bundles = this.bundleContext.getBundles();
        if (bundles == null) {
            return;
        }
        for (Bundle b : bundles) {
            if (b.getState() != 32) continue;
            this.findDeclaredRemoteServices(b);
        }
    }

    void registerTracker(ServiceReference reference, Object svc) {
        if (svc instanceof EndpointListener) {
            EndpointListener listener = (EndpointListener)svc;
            Collection<String> filters = this.addListener(reference, listener);
            this.triggerCallbacks(filters, listener);
        }
    }

    void clearTracker(Object svc) {
        if (svc instanceof EndpointListener) {
            EndpointListener listener = (EndpointListener)svc;
            this.removeListener(listener);
        }
    }

    private Collection<String> addListener(ServiceReference reference, EndpointListener listener) {
        List<String> filters = LocalDiscoveryUtils.getStringPlusProperty(reference, "endpoint.listener.scope");
        if (filters.size() == 0) {
            return filters;
        }
        this.listenerToFilters.put(listener, filters);
        for (String filter : filters) {
            if (this.filterToListeners.containsKey(filter)) {
                this.filterToListeners.get(filter).add(listener);
                continue;
            }
            ArrayList<EndpointListener> list = new ArrayList<EndpointListener>();
            list.add(listener);
            this.filterToListeners.put(filter, list);
        }
        return filters;
    }

    private void removeListener(EndpointListener listener) {
        Collection<String> filters = this.listenerToFilters.remove(listener);
        if (filters == null) {
            return;
        }
        for (String filter : filters) {
            Collection<EndpointListener> listeners = this.filterToListeners.get(filter);
            if (listeners == null) continue;
            listeners.remove(listener);
        }
    }

    public void shutDown() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.listenerTracker.close();
    }

    public void bundleChanged(BundleEvent be) {
        switch (be.getType()) {
            case 2: {
                this.findDeclaredRemoteServices(be.getBundle());
                break;
            }
            case 4: {
                this.removeServicesDeclaredInBundle(be.getBundle());
            }
        }
    }

    private void findDeclaredRemoteServices(Bundle bundle) {
        List<EndpointDescription> eds = LocalDiscoveryUtils.getAllEndpointDescriptions(bundle);
        for (EndpointDescription ed : eds) {
            this.endpointDescriptions.put(ed, bundle);
            this.addedEndpointDescription(ed);
        }
    }

    private void removeServicesDeclaredInBundle(Bundle bundle) {
        Iterator<Map.Entry<EndpointDescription, Bundle>> i = this.endpointDescriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<EndpointDescription, Bundle> entry = i.next();
            if (!bundle.equals(entry.getValue())) continue;
            this.removedEndpointDescription(entry.getKey());
            i.remove();
        }
    }

    private void addedEndpointDescription(EndpointDescription ed) {
        this.triggerCallbacks(ed, true);
    }

    private void removedEndpointDescription(EndpointDescription ed) {
        this.triggerCallbacks(ed, false);
    }

    private void triggerCallbacks(EndpointDescription ed, boolean added) {
        for (Map.Entry<EndpointListener, Collection<String>> entry : this.listenerToFilters.entrySet()) {
            for (String match : entry.getValue()) {
                this.triggerCallbacks(entry.getKey(), match, ed, added);
            }
        }
    }

    private void triggerCallbacks(EndpointListener listener, String toMatch, EndpointDescription ed, boolean added) {
        if (!this.filterMatches(toMatch, ed)) {
            return;
        }
        if (added) {
            listener.endpointAdded(ed, toMatch);
        } else {
            listener.endpointRemoved(ed, toMatch);
        }
    }

    private void triggerCallbacks(Collection<String> filters, EndpointListener listener) {
        for (String filter : filters) {
            for (EndpointDescription ed : this.endpointDescriptions.keySet()) {
                this.triggerCallbacks(listener, filter, ed, true);
            }
        }
    }

    private boolean filterMatches(String match, EndpointDescription ed) {
        Filter filter = this.createFilter(match);
        Hashtable props = new Hashtable(ed.getProperties());
        return filter != null ? filter.match(props) : false;
    }

    private Filter createFilter(String filterValue) {
        if (filterValue == null) {
            return null;
        }
        try {
            return this.bundleContext.createFilter(filterValue);
        }
        catch (Exception ex) {
            LOG.severe("Problem creating a Filter from " + filterValue);
            return null;
        }
    }
}

