/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.io.IOException;
import java.util.Dictionary;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.zookeeper.EndpointListenerFactory;
import org.apache.cxf.dosgi.discovery.zookeeper.EndpointListenerTrackerCustomizer;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperDiscovery
implements Watcher {
    private static final Logger LOG = Logger.getLogger(ZooKeeperDiscovery.class.getName());
    private boolean started = false;
    private BundleContext bctx;
    private ZooKeeper zooKeeper;
    private Dictionary properties = null;
    private EndpointListenerFactory endpointListenerFactory;
    private ServiceTracker endpointListenerTracker;
    private String zkHost;
    private String zkPort;
    private int zkTimeout;

    public ZooKeeperDiscovery(BundleContext bctx, Dictionary initialProps) {
        this.bctx = bctx;
        this.endpointListenerFactory = new EndpointListenerFactory(this, bctx);
        this.properties = initialProps;
        this.endpointListenerTracker = new ServiceTracker(bctx, EndpointListener.class.getName(), (ServiceTrackerCustomizer)new EndpointListenerTrackerCustomizer(this, bctx));
    }

    public synchronized void start() throws IOException, ConfigurationException {
        if (this.started) {
            return;
        }
        this.started = true;
        this.createZooKeeper(this.properties);
        int loops = 100;
        while (loops > 0 && this.zooKeeper.getState() != ZooKeeper.States.CONNECTED) {
            --loops;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.zooKeeper.getState() != ZooKeeper.States.CONNECTED) {
            throw new IOException("Connection to ZookeeperServer failed !");
        }
        this.endpointListenerFactory.start();
        this.endpointListenerTracker.open();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.endpointListenerFactory.stop();
        this.endpointListenerTracker.close();
    }

    private void createZooKeeper(Dictionary props) throws IOException, ConfigurationException {
        this.zkHost = ZooKeeperDiscovery.getProp(props, "zookeeper.host");
        this.zkPort = ZooKeeperDiscovery.getProp(props, "zookeeper.port");
        this.zkTimeout = Integer.parseInt(ZooKeeperDiscovery.getProp(props, "zookeeper.timeout", "3000"));
        this.zooKeeper = this.createZooKeeper();
    }

    ZooKeeper createZooKeeper() throws IOException {
        return new ZooKeeper(this.zkHost + ":" + this.zkPort, this.zkTimeout, (Watcher)this);
    }

    private <T> boolean hasChanged(T orig, T nw) {
        if (orig == nw) {
            return false;
        }
        if (orig == null) {
            return true;
        }
        return !orig.equals(nw);
    }

    private static String getProp(Dictionary props, String key) throws ConfigurationException {
        String val = ZooKeeperDiscovery.getProp(props, key, null);
        if (val != null) {
            return val;
        }
        throw new ConfigurationException(key, "The property " + key + " requires a value");
    }

    private static String getProp(Dictionary props, String key, String def) {
        Object val = props.get(key);
        String rv = val == null ? def : val.toString();
        LOG.fine("Reading Config Admin property: " + key + " value returned: " + rv);
        return rv;
    }

    public void process(WatchedEvent arg0) {
    }

    protected ZooKeeper getZookeeper() {
        return this.zooKeeper;
    }
}

