/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.zookeeper.EndpointListenerTrackerCustomizer;
import org.apache.cxf.dosgi.discovery.zookeeper.InterfaceDataMonitorListenerImpl;
import org.apache.cxf.dosgi.discovery.zookeeper.Util;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class InterfaceMonitor
implements Watcher,
AsyncCallback.StatCallback {
    private static final Logger LOG = Logger.getLogger(InterfaceMonitor.class.getName());
    InterfaceDataMonitorListenerImpl listener;
    final String znode;
    final ZooKeeper zookeeper;
    private boolean closed = false;

    public InterfaceMonitor(ZooKeeper zk, String intf, EndpointListenerTrackerCustomizer.Interest zkd, String scope, BundleContext bctx) {
        LOG.fine("Creating new InterfaceMonitor for scope [" + scope + "] and objectClass [" + intf + "] ");
        this.listener = this.createInterfaceDataMonitorListener(zk, intf, zkd, scope, bctx);
        this.zookeeper = zk;
        this.znode = Util.getZooKeeperPath(intf);
    }

    public void start() {
        this.process();
    }

    private void process() {
        LOG.finest("registering a zookeeper.exists(" + this.znode + ") callback");
        this.zookeeper.exists(this.znode, (Watcher)this, (AsyncCallback.StatCallback)this, null);
    }

    public void process(WatchedEvent event) {
        LOG.finer("ZooKeeper watcher callback " + event);
        this.processDelta();
    }

    public void processResult(int rc, String path, Object ctx, Stat stat) {
        LOG.finer("ZooKeeper callback on node: " + this.znode + "   code: " + rc);
        switch (rc) {
            case -101: 
            case 0: {
                break;
            }
            case -112: 
            case -102: 
            case -4: {
                return;
            }
            default: {
                this.process();
                return;
            }
        }
        this.processDelta();
    }

    private void processDelta() {
        if (this.closed) {
            return;
        }
        if (this.zookeeper.getState() != ZooKeeper.States.CONNECTED) {
            LOG.info("zookeeper connection was already closed! Not processing changed event.");
            return;
        }
        try {
            if (this.zookeeper.exists(this.znode, false) != null) {
                this.zookeeper.getChildren(this.znode, (Watcher)this);
                this.listener.change();
            } else {
                LOG.fine(this.znode + " doesn't exist -> not processing any changes");
            }
        }
        catch (Exception ke) {
            LOG.log(Level.SEVERE, "Error getting ZooKeeper data.", ke);
        }
    }

    public void inform(ServiceReference sref) {
        this.listener.inform(sref);
    }

    public void close() {
        this.closed = true;
    }

    protected InterfaceDataMonitorListenerImpl createInterfaceDataMonitorListener(ZooKeeper zk, String intf, EndpointListenerTrackerCustomizer.Interest zkd, String scope, BundleContext bctx) {
        return new InterfaceDataMonitorListenerImpl(zk, intf, zkd, scope, bctx, this);
    }
}

